/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.net.rabbitmq.RabbitMQHelper;
import adams.core.net.rabbitmq.send.AbstractConverter;
import adams.core.net.rabbitmq.send.StringConverter;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.RabbitMQConnection;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import com.rabbitmq.client.Channel;

public class RabbitMQPublish
extends AbstractRatOutput {
    private static final long serialVersionUID = -6705175917581201250L;
    protected String m_Exchange;
    protected String m_Queue;
    protected AbstractConverter m_Converter;
    protected transient RabbitMQConnection m_Connection;
    protected transient Channel m_Channel;

    public String globalInfo() {
        return "Publishes the incoming data using the specified exchange or queue.\nNormally, when using an exchange, leave queue empty, and when using a queue, leave the exchange empty.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("exchange", "exchange", (Object)"");
        this.m_OptionManager.add("queue", "queue", (Object)"");
        this.m_OptionManager.add("converter", "converter", (Object)new StringConverter());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"exchange", (Object)(this.m_Exchange.isEmpty() ? "-empty-" : this.m_Exchange), (String)"exchange: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"queue", (Object)(this.m_Queue.isEmpty() ? "-empty-" : this.m_Queue), (String)", queue: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"converter", (Object)this.m_Converter, (String)", converter: ");
        return result;
    }

    public void setExchange(String value) {
        this.m_Exchange = value;
        this.reset();
    }

    public String getExchange() {
        return this.m_Exchange;
    }

    public String exchangeTipText() {
        return "The name of the exchange.";
    }

    public void setQueue(String value) {
        this.m_Queue = value;
        this.reset();
    }

    public String getQueue() {
        return this.m_Queue;
    }

    public String queueTipText() {
        return "The name of the queue.";
    }

    public void setConverter(AbstractConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use.";
    }

    public Class[] accepts() {
        return this.m_Converter.accepts();
    }

    public String initTransmission() {
        String result = super.initTransmission();
        if (result == null) {
            this.m_Connection = (RabbitMQConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RabbitMQConnection.class);
            if (this.m_Connection == null) {
                result = "No " + RabbitMQConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doTransmit() {
        String result = null;
        this.m_Converter.setFlowContext((Actor)this.getOwner());
        if (this.m_Channel == null) {
            this.m_Channel = this.m_Connection.createChannel();
            if (this.m_Channel == null) {
                result = "Failed to create a channel!";
            }
        }
        byte[] data = null;
        if (result == null) {
            MessageCollection errors = new MessageCollection();
            data = this.m_Converter.convert(this.m_Input, errors);
            if (!errors.isEmpty()) {
                result = errors.toString();
            }
        }
        if (result == null) {
            try {
                this.m_Channel.basicPublish(this.m_Exchange, this.m_Queue, null, data);
            }
            catch (Exception e) {
                result = this.handleException("Failed to publish data (exchange=" + this.m_Exchange + ", queue=" + this.m_Queue + ")!", e);
            }
        }
        return result;
    }

    public void cleanUp() {
        RabbitMQHelper.closeQuietly((Channel)this.m_Channel);
        this.m_Channel = null;
        super.cleanUp();
    }
}

