/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.source.redisaction.AbstractRedisAction;
import adams.flow.source.redisaction.Null;
import adams.flow.standalone.RedisConnection;
import adams.flow.standalone.rats.input.AbstractRatInput;

public class RedisAction
extends AbstractRatInput {
    private static final long serialVersionUID = -5058805724710709734L;
    protected AbstractRedisAction m_Action;
    protected transient RedisConnection m_Connection;
    protected transient Object m_Data;

    public String globalInfo() {
        return "Executes the specified Redis action.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)new Null());
    }

    public void setAction(AbstractRedisAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractRedisAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to execute.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)this.m_Action, (String)"action: ");
    }

    public Class generates() {
        return this.m_Action.generates();
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RedisConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "Failed to locate a " + Utils.classToString(RedisConnection.class) + "!";
            }
        }
        return result;
    }

    protected String doReceive() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        try {
            this.m_Data = this.m_Action.execute(this.m_Connection, errors);
            if (!errors.isEmpty()) {
                result = errors.toString();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute action: " + this.m_Action, e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Data != null;
    }

    public Object output() {
        Object result = this.m_Data;
        this.m_Data = null;
        return result;
    }
}

