/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.input;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.redis.RedisDataType;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.RedisConnection;
import adams.flow.standalone.rats.input.AbstractBufferedRatInput;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;

public class RedisSubscribe
extends AbstractBufferedRatInput {
    private static final long serialVersionUID = -5856410764771164718L;
    protected String m_Channel;
    protected RedisDataType m_Type;
    protected transient RedisConnection m_Connection;
    protected transient StatefulRedisPubSubConnection m_PubSubConnection;
    protected transient RedisPubSubListener m_PubSubListener;

    public String globalInfo() {
        return "Executes the specified Redis channel.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("channel", "channel", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)RedisDataType.STRING);
    }

    public void setChannel(String value) {
        this.m_Channel = value;
        this.reset();
    }

    public String getChannel() {
        return this.m_Channel;
    }

    public String channelTipText() {
        return "The channel to subscribe to.";
    }

    public void setType(RedisDataType value) {
        this.m_Type = value;
        this.reset();
    }

    public RedisDataType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the data.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"channel", (Object)(this.m_Channel.isEmpty() ? "-empty-" : this.m_Channel), (String)"channel: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)", type: ");
        return result;
    }

    public Class generates() {
        return this.m_Type.getDataClass();
    }

    protected RedisPubSubListener<String, String> newStringListener() {
        return new RedisPubSubListener<String, String>(){

            public void message(String channel, String message) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Message on channel '" + channel + "': " + message);
                }
                RedisSubscribe.this.bufferData(message);
            }

            public void message(String pattern, String channel, String message) {
                this.message(channel, message);
            }

            public void subscribed(String channel, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Subscribed to channel: " + channel);
                }
            }

            public void psubscribed(String pattern, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Subscribed to pattern: " + pattern);
                }
            }

            public void unsubscribed(String channel, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Unsubscribed from channel: " + channel);
                }
            }

            public void punsubscribed(String pattern, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Unsubscribed from pattern: " + pattern);
                }
            }
        };
    }

    protected RedisPubSubListener<byte[], byte[]> newBytesListener() {
        return new RedisPubSubListener<byte[], byte[]>(){

            public void message(byte[] channel, byte[] message) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Message on channel '" + new String(channel) + "': " + new String(message));
                }
                RedisSubscribe.this.bufferData(message);
            }

            public void message(byte[] pattern, byte[] channel, byte[] message) {
                this.message(channel, message);
            }

            public void subscribed(byte[] channel, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Subscribed to channel: " + new String(channel));
                }
            }

            public void psubscribed(byte[] pattern, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Subscribed to pattern: " + new String(pattern));
                }
            }

            public void unsubscribed(byte[] channel, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Unsubscribed from channel: " + new String(channel));
                }
            }

            public void punsubscribed(byte[] pattern, long count) {
                if (RedisSubscribe.this.isLoggingEnabled()) {
                    RedisSubscribe.this.getLogger().info("Unsubscribed from pattern: " + new String(pattern));
                }
            }
        };
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this.m_Owner, RedisConnection.class, (boolean)true);
            if (this.m_Connection == null) {
                result = "Failed to locate a " + Utils.classToString(RedisConnection.class) + "!";
            }
        }
        return result;
    }

    public String initReception() {
        String result = super.initReception();
        if (result == null) {
            switch (this.m_Type) {
                case STRING: {
                    this.m_PubSubListener = this.newStringListener();
                    this.m_PubSubConnection = this.m_Connection.getClient().connectPubSub((RedisCodec)StringCodec.UTF8);
                    this.m_PubSubConnection.addListener(this.m_PubSubListener);
                    this.m_PubSubConnection.async().subscribe(new Object[]{this.m_Channel});
                    break;
                }
                case BYTE_ARRAY: {
                    this.m_PubSubListener = this.newBytesListener();
                    this.m_PubSubConnection = this.m_Connection.getClient().connectPubSub((RedisCodec)new ByteArrayCodec());
                    this.m_PubSubConnection.addListener(this.m_PubSubListener);
                    this.m_PubSubConnection.async().subscribe(new Object[]{this.m_Channel.getBytes()});
                    break;
                }
                default: {
                    result = "Unhandled redis data type (setting up pub/sub): " + this.m_Type;
                }
            }
        }
        return result;
    }

    protected String doReceive() {
        return null;
    }

    protected void cleanUpRedis() {
        if (this.m_PubSubConnection != null) {
            if (this.m_PubSubListener != null) {
                this.m_PubSubConnection.removeListener(this.m_PubSubListener);
            }
            switch (this.m_Type) {
                case STRING: {
                    this.m_PubSubConnection.async().unsubscribe(new Object[]{this.m_Channel});
                    break;
                }
                case BYTE_ARRAY: {
                    this.m_PubSubConnection.async().unsubscribe(new Object[]{this.m_Channel.getBytes()});
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled redis data type (unsubscribing): " + this.m_Type);
                }
            }
        }
        this.m_PubSubConnection = null;
        this.m_PubSubListener = null;
    }

    public void stopExecution() {
        this.cleanUpRedis();
        super.stopExecution();
    }

    public void cleanUp() {
        this.cleanUpRedis();
        super.cleanUp();
    }
}

