/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZooResolver;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.JsonUtils;
import ai.djl.util.Utils;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelZoo {
    public static final URI DJL_REPO_URL = URI.create(Utils.getEnvOrSystemProperty("DJL_REPO_URL", "https://mlrepo.djl.ai/"));
    private static final Logger logger = LoggerFactory.getLogger(ModelZoo.class);
    private static final Map<String, ModelZoo> MODEL_ZOO_MAP = new ConcurrentHashMap<String, ModelZoo>();
    private static final long ONE_DAY = Duration.ofDays(1L).toMillis();
    private static ModelZooResolver resolver;
    private Map<String, ModelLoader> modelLoaders = new ConcurrentHashMap<String, ModelLoader>();

    public abstract String getGroupId();

    public Collection<ModelLoader> getModelLoaders() {
        return this.modelLoaders.values();
    }

    public ModelLoader getModelLoader(String name) {
        return this.modelLoaders.get(name);
    }

    public abstract Set<String> getSupportedEngines();

    protected final void addModel(MRL mrl) {
        this.modelLoaders.put(mrl.getArtifactId(), new BaseModelLoader(mrl));
    }

    protected final void addModel(ModelLoader loader) {
        this.modelLoaders.put(loader.getArtifactId(), loader);
    }

    public static void setModelZooResolver(ModelZooResolver resolver) {
        ModelZoo.resolver = resolver;
    }

    public static void registerModelZoo(ZooProvider provider) {
        ModelZoo zoo = provider.getModelZoo();
        MODEL_ZOO_MAP.put(zoo.getGroupId(), zoo);
    }

    public static Collection<ModelZoo> listModelZoo() {
        return MODEL_ZOO_MAP.values();
    }

    public static ModelZoo getModelZoo(String groupId) {
        ModelZoo zoo = MODEL_ZOO_MAP.get(groupId);
        if (zoo == null && resolver != null && (zoo = resolver.resolve(groupId)) != null) {
            MODEL_ZOO_MAP.putIfAbsent(groupId, zoo);
        }
        return zoo;
    }

    public static boolean hasModelZoo(String groupId) {
        return MODEL_ZOO_MAP.containsKey(groupId);
    }

    public static <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        return criteria.loadModel();
    }

    public static Map<Application, List<MRL>> listModels() {
        return ModelZoo.listModels(Criteria.builder().build());
    }

    public static Map<Application, List<MRL>> listModels(Criteria<?, ?> criteria) {
        String artifactId = criteria.getArtifactId();
        ModelZoo modelZoo = criteria.getModelZoo();
        String groupId = criteria.getGroupId();
        String engine = criteria.getEngine();
        Application application = criteria.getApplication();
        TreeMap<Application, List<MRL>> models = new TreeMap<Application, List<MRL>>(Comparator.comparing(Application::getPath));
        for (ModelZoo zoo : ModelZoo.listModelZoo()) {
            if (modelZoo != null) {
                if (groupId != null && !modelZoo.getGroupId().equals(groupId)) continue;
                Set<String> supportedEngine = modelZoo.getSupportedEngines();
                if (engine != null && !supportedEngine.contains(engine)) continue;
            }
            for (ModelLoader loader : zoo.getModelLoaders()) {
                Application app = loader.getApplication();
                String loaderArtifactId = loader.getArtifactId();
                if (artifactId != null && !artifactId.equals(loaderArtifactId) || application != Application.UNDEFINED && app != Application.UNDEFINED && !app.matches(application)) continue;
                models.compute(app, (key, val) -> {
                    if (val == null) {
                        val = new ArrayList<MRL>();
                    }
                    val.add(loader.getMrl());
                    return val;
                });
            }
        }
        return models;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Map<String, Object>> listModels(Repository repo, Application app) {
        try {
            String groupId = this.getGroupId();
            String path = "model/" + app.getPath() + '/' + groupId.replace('.', '/') + '/';
            Path dir = Utils.getCacheDir().resolve("cache/repo/" + path);
            if (Files.notExists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            } else if (!Files.isDirectory(dir, new LinkOption[0])) {
                logger.warn("Failed initialize cache directory: {}", (Object)dir);
                return Collections.emptyMap();
            }
            Type type = new TypeToken<Map<String, Map<String, Object>>>(){}.getType();
            Path file = dir.resolve("models.json");
            if (Files.exists(file, new LinkOption[0])) {
                long lastModified = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
                if (Utils.isOfflineMode() || System.currentTimeMillis() - lastModified < ONE_DAY) {
                    try (BufferedReader reader = Files.newBufferedReader(file);){
                        Map map = (Map)JsonUtils.GSON.fromJson((Reader)reader, type);
                        return map;
                    }
                }
            }
            URI uri = repo.getBaseUri().resolve(path + "models.json.gz");
            Path tmp = Files.createTempFile(dir, "models", ".tmp", new FileAttribute[0]);
            try {
                Object writer2;
                GZIPInputStream gis = new GZIPInputStream(Utils.openUrl(uri.toURL()));
                try {
                    String json = Utils.toString(gis);
                    writer2 = Files.newBufferedWriter(tmp, new OpenOption[0]);
                    try {
                        ((Writer)writer2).write(json);
                    }
                    finally {
                        if (writer2 != null) {
                            ((Writer)writer2).close();
                        }
                    }
                    Utils.moveQuietly(tmp, file);
                    writer2 = (Map)JsonUtils.GSON.fromJson(json, type);
                }
                catch (Throwable json) {
                    try {
                        try {
                            gis.close();
                        }
                        catch (Throwable writer2) {
                            json.addSuppressed(writer2);
                        }
                        throw json;
                    }
                    catch (IOException e) {
                        logger.warn("Failed to download Huggingface model zoo index: {}", (Object)app);
                        if (Files.exists(file, new LinkOption[0])) {
                            try (BufferedReader reader = Files.newBufferedReader(file);){
                                Map writer2 = (Map)JsonUtils.GSON.fromJson((Reader)reader, type);
                                return writer2;
                            }
                        }
                        String resource = app.getPath() + "/" + groupId + ".json";
                        try (InputStream is = ClassLoaderUtils.getResourceAsStream(resource);){
                            String json2 = Utils.toString(is);
                            try (BufferedWriter writer3 = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                                writer3.write(json2);
                            }
                            Utils.moveQuietly(tmp, file);
                            Map map = (Map)JsonUtils.GSON.fromJson(json2, type);
                            return map;
                        }
                    }
                }
                gis.close();
                return writer2;
            }
            finally {
                Utils.deleteQuietly(tmp);
            }
        }
        catch (IOException e) {
            logger.warn("Failed load index of models: {}", (Object)app, (Object)e);
            return Collections.emptyMap();
        }
    }

    static {
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo.registerModelZoo(provider);
        }
    }
}

