/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Scanner;
import org.apache.maven.plugin.logging.Log;

public abstract class FileRenderer
implements ChangeLogRenderer {
    protected Writer writer;
    protected final Log log;

    public FileRenderer(Log log, File targetFolder, String filename) throws IOException {
        this.log = log;
        File file = new File(targetFolder, filename);
        log.debug((CharSequence)("Creating git changelog at " + file.getAbsolutePath()));
        this.writer = new FileWriter(file);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                this.log.error((CharSequence)"Could not flush file to disk", (Throwable)e);
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String convertStreamToString(InputStream is) {
        Scanner scanner = new Scanner(is, "UTF-8");
        String first = scanner.useDelimiter("\\A").next();
        scanner.close();
        return first;
    }

    protected String loadResourceToString(String resourcePath) throws IOException {
        InputStream templateStream = this.getClass().getResourceAsStream(resourcePath);
        String s = this.convertStreamToString(templateStream);
        templateStream.close();
        return s;
    }
}

