/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.simpleargparse4j;

import com.github.fracpete.simpleargparse4j.ArgumentParserException;
import com.github.fracpete.simpleargparse4j.HelpRequestedException;
import com.github.fracpete.simpleargparse4j.InvalidArgumentException;
import com.github.fracpete.simpleargparse4j.MissingArgumentException;
import com.github.fracpete.simpleargparse4j.Namespace;
import com.github.fracpete.simpleargparse4j.Option;
import com.github.fracpete.simpleargparse4j.RequiredOptionMissingException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ArgumentParser
implements Serializable {
    public static final int SCREEN_WIDTH = 80;
    public static final int TAB_WIDTH = 8;
    public static final char[] BREAK_CHARS = " ,;!?".toCharArray();
    protected String m_Description;
    protected List<Option> m_Options;
    protected boolean m_HelpRequested;
    protected int m_ScreenWidth;
    protected char[] m_BreakChars;

    public ArgumentParser(String description) {
        this.m_Description = description;
        this.m_Options = new ArrayList<Option>();
        this.m_ScreenWidth = 80;
        this.m_BreakChars = BREAK_CHARS;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public ArgumentParser screenWidth(int value) {
        this.m_ScreenWidth = value;
        return this;
    }

    public int getScreenWidth() {
        return this.m_ScreenWidth;
    }

    public ArgumentParser breakChars(char[] value) {
        this.m_BreakChars = value;
        return this;
    }

    public char[] getBreakChars() {
        return this.m_BreakChars;
    }

    public Option addOption(String flag) {
        Option result = new Option(flag);
        this.m_Options.add(result);
        return result;
    }

    public Option addOption(String flag, String secondFlag) {
        Option result = new Option(flag, secondFlag);
        this.m_Options.add(result);
        return result;
    }

    public List<Option> getOptions() {
        return this.m_Options;
    }

    public Namespace parseArgs(String[] args) throws ArgumentParserException {
        return this.parseArgs(args, false);
    }

    public Namespace parseArgs(String[] args, boolean remove) throws ArgumentParserException {
        return this.parseArgs(args, remove, false);
    }

    public Namespace parseArgs(String[] args, boolean remove, boolean noErrors) throws ArgumentParserException {
        Namespace result = new Namespace(this.m_Options);
        HashMap<String, Option> mapped = new HashMap<String, Option>();
        HashSet<Option> required = new HashSet<Option>();
        for (Option opt : this.m_Options) {
            mapped.put(opt.getFlag(), opt);
            if (opt.hasSecondFlag()) {
                mapped.put(opt.getSecondFlag(), opt);
            }
            if (!opt.isRequired()) continue;
            required.add(opt);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--help")) {
                this.m_HelpRequested = true;
                if (!noErrors) {
                    throw new HelpRequestedException();
                }
            }
            if (!mapped.containsKey(args[i])) continue;
            Option option = (Option)mapped.get(args[i]);
            if (option.hasArgument()) {
                if (i == args.length - 1) {
                    throw new MissingArgumentException("No argument supplied: " + option.getFlag());
                }
                if (!option.isValid(args[i + 1])) {
                    throw new InvalidArgumentException(option.getFlag(), option.getType(), args[i + 1]);
                }
                if (option.isMultiple()) {
                    result.addValue(option.getDest(), option.parse(args[i + 1]));
                } else {
                    result.setValue(option.getDest(), option.parse(args[i + 1]));
                }
                if (remove) {
                    args[i] = "";
                    args[i + 1] = "";
                    ++i;
                }
            } else {
                if (option.isMultiple()) {
                    result.addValue(option.getDest(), result.flipDefault(option.getDest()));
                } else {
                    result.setValue(option.getDest(), result.flipDefault(option.getDest()));
                }
                if (remove) {
                    args[i] = "";
                }
            }
            required.remove(option);
        }
        if (required.size() > 0 && !noErrors) {
            throw new RequiredOptionMissingException(required);
        }
        return result;
    }

    public String generateHelpScreen(boolean requested) {
        return this.generateHelpScreen(requested, true, true, true);
    }

    protected int leftIndex(String s, char c, int start) {
        int result = -1;
        for (int i = start; i >= 0; --i) {
            if (s.charAt(i) != c) continue;
            result = i;
            break;
        }
        return result;
    }

    protected List<String> breakUp(String line, int max) {
        ArrayList<String> result = new ArrayList<String>();
        int[] pos = new int[this.m_BreakChars.length];
        do {
            if (line.length() > max) {
                int i;
                for (i = 0; i < this.m_BreakChars.length; ++i) {
                    pos[i] = this.leftIndex(line, this.m_BreakChars[i], max);
                }
                int index = 0;
                for (i = 0; i < this.m_BreakChars.length; ++i) {
                    if (pos[i] <= -1 || pos[i] <= index) continue;
                    index = pos[i];
                }
                if (index > 0) {
                    result.add(line.substring(0, index + 1).trim());
                    line = line.substring(index + 1).trim();
                    continue;
                }
                result.add(line.substring(0, max).trim());
                line = line.substring(max).trim();
                continue;
            }
            result.add(line);
            line = "";
        } while (line.length() > 0);
        return result;
    }

    public String generateHelpScreen(boolean requested, boolean desc, boolean usage, boolean options) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        if (requested) {
            result.append("Help requested");
            result.append("\n\n");
        }
        if (desc) {
            lines = this.m_Description.split("\n");
            for (String line : lines) {
                for (String fitted : this.breakUp(line, this.m_ScreenWidth)) {
                    result.append(fitted).append("\n");
                }
            }
            result.append("\n\n");
        }
        if (usage) {
            result.append("Usage: [--help]");
            for (Option opt : this.m_Options) {
                int width = result.length() - result.lastIndexOf("\n");
                int optwidth = opt.getFlag().length();
                if (opt.hasSecondFlag()) {
                    optwidth += 2 + opt.getSecondFlag().length();
                }
                if (!opt.isRequired()) {
                    optwidth += 2;
                }
                if (opt.hasArgument()) {
                    optwidth = opt.hasMetaVar() ? (optwidth += 1 + opt.getMetaVar().length()) : (optwidth += 1 + opt.getDest().length());
                }
                if (opt.isMultiple()) {
                    optwidth += 3;
                }
                if (width + optwidth + 1 > this.m_ScreenWidth) {
                    result.append("\n").append("      ");
                }
                result.append(" ");
                if (!opt.isRequired()) {
                    result.append("[");
                }
                result.append(opt.getFlag());
                if (opt.hasArgument()) {
                    if (opt.hasMetaVar()) {
                        result.append(" ").append(opt.getMetaVar().toUpperCase());
                    } else {
                        result.append(" ").append(opt.getDest().toUpperCase());
                    }
                }
                if (opt.isMultiple()) {
                    result.append("...");
                }
                if (opt.isRequired()) continue;
                result.append("]");
            }
            result.append("\n\n");
        }
        if (options) {
            result.append("Options:\n");
            for (Option opt : this.m_Options) {
                result.append(opt.getFlag());
                if (opt.hasSecondFlag()) {
                    result.append(", ").append(opt.getSecondFlag());
                }
                if (opt.hasArgument()) {
                    if (opt.hasMetaVar()) {
                        result.append(" ").append(opt.getMetaVar().toUpperCase());
                    } else {
                        result.append(" ").append(opt.getDest().toUpperCase());
                    }
                }
                result.append("\n");
                for (String line : lines = opt.getHelp().split("\n")) {
                    for (String fitted : this.breakUp(line, this.m_ScreenWidth - 8)) {
                        result.append("\t").append(fitted).append("\n");
                    }
                }
                result.append("\n");
            }
        }
        return result.toString();
    }

    public boolean getHelpRequested() {
        return this.m_HelpRequested;
    }

    public void handleError(ArgumentParserException e) {
        if (e instanceof HelpRequestedException) {
            System.out.println(this.generateHelpScreen(true));
            return;
        }
        System.err.println(e.toString());
        e.printStackTrace();
        System.err.println(this.generateHelpScreen(false));
    }
}

