/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.simpleargparse4j;

import java.io.File;
import java.io.Serializable;
import java.util.List;

public class Option
implements Serializable,
Comparable<Option> {
    protected String m_Dest;
    protected String m_Flag;
    protected String m_SecondFlag;
    protected boolean m_HasArgument;
    protected Object m_DefaultValue;
    protected boolean m_HasDefaultValue;
    protected String m_Help;
    protected boolean m_Required;
    protected boolean m_Multiple;
    protected Type m_Type;
    protected String m_MetaVar;

    public Option(String flag) {
        this(flag.replace("-", ""), flag, true, null, flag.replace("-", ""), false, false, Type.STRING);
    }

    public Option(String flag, String secondFlag) {
        this(secondFlag != null ? secondFlag.replace("-", "") : flag.replace("-", ""), flag, secondFlag, true, null, flag.replace("-", ""), false, false, Type.STRING);
    }

    public Option(String dest, String flag, boolean hasArg, String defValue, String help, boolean required, boolean multiple, Type type) {
        this(dest, flag, null, hasArg, defValue, help, required, multiple, type);
    }

    public Option(String dest, String flag, String secondFlag, boolean hasArg, String defValue, String help, boolean required, boolean multiple, Type type) {
        this.m_Dest = dest;
        this.m_Flag = flag;
        this.m_SecondFlag = secondFlag;
        this.m_HasArgument = hasArg;
        this.m_DefaultValue = defValue;
        this.m_HasDefaultValue = true;
        this.m_Help = help;
        this.m_Required = required;
        this.m_Multiple = multiple;
        this.m_Type = type;
    }

    public Option dest(String value) {
        this.m_Dest = value;
        return this;
    }

    public Option argument(boolean value) {
        this.m_HasArgument = value;
        if (!this.m_HasArgument) {
            this.type(Type.BOOLEAN);
        }
        return this;
    }

    public Option noDefault() {
        if (this.isMultiple()) {
            ((List)this.getDefault()).clear();
        } else {
            this.m_DefaultValue = null;
        }
        this.m_HasDefaultValue = false;
        return this;
    }

    public boolean hasDefaultValue() {
        return this.m_HasDefaultValue;
    }

    public Option setDefault(String value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(boolean value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(byte value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(short value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(int value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(long value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option setDefault(float value) {
        this.m_DefaultValue = Float.valueOf(value);
        return this;
    }

    public Option setDefault(double value) {
        this.m_DefaultValue = value;
        return this;
    }

    public Option help(String value) {
        this.m_Help = value;
        return this;
    }

    public Option required(boolean value) {
        this.m_Required = value;
        if (!value) {
            this.noDefault();
        }
        return this;
    }

    public Option multiple(boolean value) {
        this.m_Multiple = value;
        return this;
    }

    public Option type(Type value) {
        this.m_Type = value;
        if (this.m_Type == Type.BOOLEAN) {
            this.m_HasArgument = false;
        }
        return this;
    }

    public Option metaVar(String value) {
        this.m_MetaVar = value;
        return this;
    }

    public String getDest() {
        return this.m_Dest;
    }

    public String getFlag() {
        return this.m_Flag;
    }

    public boolean hasSecondFlag() {
        return this.m_SecondFlag != null;
    }

    public String getSecondFlag() {
        return this.m_SecondFlag;
    }

    public boolean hasArgument() {
        return this.m_HasArgument;
    }

    public <E> E getDefault() {
        return (E)this.m_DefaultValue;
    }

    public String getHelp() {
        return this.m_Help;
    }

    public boolean isRequired() {
        return this.m_Required;
    }

    public boolean isMultiple() {
        return this.m_Multiple;
    }

    public Type getType() {
        return this.m_Type;
    }

    public boolean hasMetaVar() {
        return this.m_MetaVar != null;
    }

    public String getMetaVar() {
        return this.m_MetaVar;
    }

    public boolean isValid(String value) {
        try {
            switch (this.getType()) {
                case BOOLEAN: {
                    Boolean.parseBoolean(value);
                    break;
                }
                case BYTE: {
                    Byte.parseByte(value);
                    break;
                }
                case SHORT: {
                    Short.parseShort(value);
                    break;
                }
                case INTEGER: {
                    Integer.parseInt(value);
                    break;
                }
                case LONG: {
                    Long.parseLong(value);
                    break;
                }
                case FLOAT: {
                    Float.parseFloat(value);
                    break;
                }
                case DOUBLE: {
                    Double.parseDouble(value);
                    break;
                }
                case STRING: {
                    return true;
                }
                case FILE: {
                    File file = new File(value);
                    return !file.exists() || !file.isDirectory();
                }
                case DIRECTORY: {
                    File file = new File(value);
                    return !file.exists() || file.isDirectory();
                }
                case FILE_OR_DIRECTORY: {
                    return true;
                }
                case EXISTING_FILE: {
                    File file = new File(value);
                    return file.exists() && !file.isDirectory();
                }
                case EXISTING_DIR: {
                    File file = new File(value);
                    return file.exists() && file.isDirectory();
                }
                case EXISTING_FILE_OR_DIRECTORY: {
                    File file = new File(value);
                    return file.exists();
                }
                case NONEXISTING_DIR: 
                case NONEXISTING_FILE: 
                case NONEXISTING_FILE_OR_DIRECTORY: {
                    File file = new File(value);
                    return !file.exists();
                }
                default: {
                    throw new IllegalStateException("Unhandled type (for option '" + this.getDest() + "'): " + (Object)((Object)this.getType()));
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object parse(String value) {
        switch (this.getType()) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case BYTE: {
                return Byte.parseByte(value);
            }
            case SHORT: {
                return Short.parseShort(value);
            }
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case STRING: {
                return value;
            }
            case FILE: 
            case DIRECTORY: 
            case FILE_OR_DIRECTORY: 
            case EXISTING_FILE: 
            case EXISTING_DIR: 
            case EXISTING_FILE_OR_DIRECTORY: 
            case NONEXISTING_DIR: 
            case NONEXISTING_FILE: 
            case NONEXISTING_FILE_OR_DIRECTORY: {
                return new File(value);
            }
        }
        throw new IllegalStateException("Unhandled type (for option '" + this.getDest() + "'): " + (Object)((Object)this.getType()));
    }

    @Override
    public int compareTo(Option o) {
        return this.m_Dest.compareTo(o.getDest());
    }

    public boolean equals(Object obj) {
        return obj instanceof Option && this.compareTo((Option)obj) == 0;
    }

    public int hashCode() {
        return this.m_Dest.hashCode();
    }

    public String toString() {
        return "name=" + this.m_Dest + ", flag=" + this.m_Flag + ", secondFlag=" + (this.m_SecondFlag == null ? "-no-" : this.m_SecondFlag) + ", hasArg=" + this.m_HasArgument + ", defValue=" + this.m_DefaultValue + ", help=" + this.m_Help + ", required=" + this.m_Required + ", multiple=" + this.m_Multiple;
    }

    public static enum Type {
        STRING,
        BOOLEAN,
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        FILE,
        DIRECTORY,
        FILE_OR_DIRECTORY,
        EXISTING_FILE,
        EXISTING_DIR,
        EXISTING_FILE_OR_DIRECTORY,
        NONEXISTING_FILE,
        NONEXISTING_DIR,
        NONEXISTING_FILE_OR_DIRECTORY;

    }
}

