/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.simpleargparse4j;

import com.github.fracpete.simpleargparse4j.Option;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
implements Serializable {
    protected Map<String, Object> m_Values = new HashMap<String, Object>();

    public Namespace(List<Option> options) {
        this.init(options);
    }

    protected void init(List<Option> options) {
        block22: for (Option option : options) {
            if (option.getDefault() != null) {
                this.m_Values.put(option.getDest(), option.getDefault());
            }
            if (this.m_Values.containsKey(option.getDest())) continue;
            if (option.isMultiple()) {
                switch (option.getType()) {
                    case BOOLEAN: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case BYTE: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case SHORT: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case INTEGER: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case LONG: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case FLOAT: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case DOUBLE: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case STRING: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                    case FILE: 
                    case DIRECTORY: 
                    case FILE_OR_DIRECTORY: 
                    case EXISTING_FILE: 
                    case EXISTING_DIR: 
                    case EXISTING_FILE_OR_DIRECTORY: 
                    case NONEXISTING_FILE: 
                    case NONEXISTING_DIR: 
                    case NONEXISTING_FILE_OR_DIRECTORY: {
                        this.setDefault(option.getDest(), new ArrayList());
                        continue block22;
                    }
                }
                throw new IllegalStateException("Unhandled list type (for option '" + option.getDest() + "'): " + (Object)((Object)option.getType()));
            }
            if (!option.hasDefaultValue()) continue;
            switch (option.getType()) {
                case BOOLEAN: {
                    this.setDefault(option.getDest(), false);
                    continue block22;
                }
                case BYTE: {
                    this.setDefault(option.getDest(), 0);
                    continue block22;
                }
                case SHORT: {
                    this.setDefault(option.getDest(), 0);
                    continue block22;
                }
                case INTEGER: {
                    this.setDefault(option.getDest(), 0);
                    continue block22;
                }
                case LONG: {
                    this.setDefault(option.getDest(), 0L);
                    continue block22;
                }
                case FLOAT: {
                    this.setDefault(option.getDest(), 0.0f);
                    continue block22;
                }
                case DOUBLE: {
                    this.setDefault(option.getDest(), 0.0);
                    continue block22;
                }
                case STRING: {
                    this.setDefault(option.getDest(), "");
                    continue block22;
                }
                case FILE: 
                case DIRECTORY: 
                case FILE_OR_DIRECTORY: 
                case EXISTING_FILE: 
                case EXISTING_DIR: 
                case EXISTING_FILE_OR_DIRECTORY: 
                case NONEXISTING_FILE: 
                case NONEXISTING_DIR: 
                case NONEXISTING_FILE_OR_DIRECTORY: {
                    this.setDefault(option.getDest(), new File("."));
                    continue block22;
                }
            }
            throw new IllegalStateException("Unhandled list type (for option '" + option.getDest() + "'): " + (Object)((Object)option.getType()));
        }
    }

    public void setDefault(String name, String value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, byte value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, short value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, int value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, long value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, float value) {
        this.m_Values.put(name, Float.valueOf(value));
    }

    public void setDefault(String name, double value) {
        this.m_Values.put(name, value);
    }

    public void setDefault(String name, File value) {
        this.m_Values.put(name, value);
    }

    public <E> void setDefault(String name, List<E> value) {
        this.m_Values.put(name, value);
    }

    public void setValue(String name, Object value) {
        this.m_Values.put(name, value);
    }

    public void addValue(String name, Object value) {
        this.getList(name).add(value);
    }

    public boolean flipDefault(String name) {
        return !this.m_Values.get(name).equals(true);
    }

    public String getString(String name) {
        return (String)this.m_Values.get(name);
    }

    public boolean getBoolean(String name) {
        return Boolean.parseBoolean("" + this.m_Values.get(name));
    }

    public byte getByte(String name) {
        return Byte.parseByte("" + this.m_Values.get(name));
    }

    public short getShort(String name) {
        return Short.parseShort("" + this.m_Values.get(name));
    }

    public int getInt(String name) {
        return Integer.parseInt("" + this.m_Values.get(name));
    }

    public long getLong(String name) {
        return Long.parseLong("" + this.m_Values.get(name));
    }

    public float getFloat(String name) {
        return Float.parseFloat("" + this.m_Values.get(name));
    }

    public double getDouble(String name) {
        return Double.parseDouble("" + this.m_Values.get(name));
    }

    public File getFile(String name) {
        if (this.m_Values.get(name) == null) {
            return null;
        }
        return new File("" + this.m_Values.get(name));
    }

    public <E> List<E> getList(String name) {
        return (List)this.m_Values.get(name);
    }

    public String toString() {
        return this.m_Values.toString();
    }
}

