/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi;

import io.vertx.core.AsyncResult;
import io.vertx.core.Deployable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.util.concurrent.Callable;

public interface VerticleFactory {
    public static String removePrefix(String identifer) {
        int pos = identifer.indexOf(58);
        if (pos != -1) {
            if (pos == identifer.length() - 1) {
                throw new IllegalArgumentException("Invalid identifier: " + identifer);
            }
            return identifer.substring(pos + 1);
        }
        return identifer;
    }

    default public int order() {
        return 0;
    }

    default public void init(Vertx vertx) {
    }

    default public void close() {
    }

    public String prefix();

    @Deprecated
    default public void createVerticle(String verticleName, ClassLoader classLoader, Promise<Callable<Verticle>> promise) {
        promise.fail("Should not be called, now deploys deployable");
    }

    default public void createVerticle2(String verticleName, ClassLoader classLoader, Promise<Callable<? extends Deployable>> promise) {
        Promise<Callable<Verticle>> p = Promise.promise();
        this.createVerticle(verticleName, classLoader, p);
        Future<Callable<Verticle>> fut = p.future();
        AsyncResult f = fut.map(callable -> callable);
        fut.onComplete(promise);
    }
}

