/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ConsumerGroupDescriptionConverter;
import io.vertx.kafka.admin.MemberDescription;
import io.vertx.kafka.client.common.Node;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.acl.AclOperation;

@DataObject
@JsonGen(publicConverter=false)
public class ConsumerGroupDescription {
    private String groupId;
    private boolean isSimpleConsumerGroup;
    private Node coordinator;
    private List<MemberDescription> members;
    private String partitionAssignor;
    private ConsumerGroupState state;
    private Set<AclOperation> authorizedOperations;

    public ConsumerGroupDescription() {
    }

    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, List<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator, Set<AclOperation> authorizedOperations) {
        this.groupId = groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.members = members;
        this.partitionAssignor = partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
        this.authorizedOperations = authorizedOperations;
    }

    public ConsumerGroupDescription(JsonObject json) {
        ConsumerGroupDescriptionConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public ConsumerGroupDescription setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public ConsumerGroupDescription setSimpleConsumerGroup(boolean isSimpleConsumerGroup) {
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        return this;
    }

    public Node getCoordinator() {
        return this.coordinator;
    }

    public ConsumerGroupDescription setCoordinator(Node coordinator) {
        this.coordinator = coordinator;
        return this;
    }

    public List<MemberDescription> getMembers() {
        return this.members;
    }

    public ConsumerGroupDescription setMembers(List<MemberDescription> members) {
        this.members = members;
        return this;
    }

    public String getPartitionAssignor() {
        return this.partitionAssignor;
    }

    public ConsumerGroupDescription setPartitionAssignor(String partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
        return this;
    }

    public ConsumerGroupState getState() {
        return this.state;
    }

    public ConsumerGroupDescription setState(ConsumerGroupState state) {
        this.state = state;
        return this;
    }

    public Set<AclOperation> getAuthorizedOperations() {
        return this.authorizedOperations;
    }

    public ConsumerGroupDescription setAuthorizedOperations(Set<AclOperation> authorizedOperations) {
        this.authorizedOperations = authorizedOperations;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        ConsumerGroupDescriptionConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return "ConsumerGroupDescription{groupId=" + this.groupId + ",isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ",coordinator=" + String.valueOf(this.coordinator) + ",members=" + String.valueOf(this.members) + ",partitionAssignor=" + this.partitionAssignor + ",state=" + String.valueOf(this.state) + ",authorizedOperations=" + String.valueOf(this.authorizedOperations) + "}";
    }
}

