/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.impl.VertxMetricsImpl;
import io.vertx.micrometer.impl.meters.LongGauges;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

public class MicrometerMetricsFactory
implements VertxMetricsFactory {
    private static final Map<MeterRegistry, ConcurrentMap<Meter.Id, LongAdder>> longGaugesByRegistry = new WeakHashMap<MeterRegistry, ConcurrentMap<Meter.Id, LongAdder>>(1);
    private final MeterRegistry micrometerRegistry;

    public MicrometerMetricsFactory() {
        this(null);
    }

    public MicrometerMetricsFactory(MeterRegistry micrometerRegistry) {
        this.micrometerRegistry = micrometerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VertxMetrics metrics(VertxOptions vertxOptions) {
        ConcurrentMap longGauges;
        MetricsOptions metricsOptions = vertxOptions.getMetricsOptions();
        MicrometerMetricsOptions options = metricsOptions instanceof MicrometerMetricsOptions ? (MicrometerMetricsOptions)metricsOptions : new MicrometerMetricsOptions(metricsOptions.toJson());
        BackendRegistry backendRegistry = BackendRegistries.setupBackend(options, this.micrometerRegistry);
        Map<MeterRegistry, ConcurrentMap<Meter.Id, LongAdder>> map = longGaugesByRegistry;
        synchronized (map) {
            longGauges = longGaugesByRegistry.computeIfAbsent(backendRegistry.getMeterRegistry(), meterRegistry -> new ConcurrentHashMap());
        }
        VertxMetricsImpl metrics = new VertxMetricsImpl(options, backendRegistry, new LongGauges(longGauges));
        metrics.init();
        return metrics;
    }

    public MetricsOptions newOptions(MetricsOptions options) {
        if (options instanceof MicrometerMetricsOptions) {
            return new MicrometerMetricsOptions((MicrometerMetricsOptions)options);
        }
        return super.newOptions(options);
    }

    public MetricsOptions newOptions() {
        return this.newOptions((JsonObject)null);
    }

    public MetricsOptions newOptions(JsonObject jsonObject) {
        return jsonObject == null ? new MicrometerMetricsOptions() : new MicrometerMetricsOptions(jsonObject);
    }
}

