/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;

public class PrometheusRequestHandlerImpl
implements Handler<HttpServerRequest> {
    private final PrometheusMeterRegistry registry;
    private final String metricsEndpoint;

    public PrometheusRequestHandlerImpl(PrometheusMeterRegistry registry, String metricsEndpoint) {
        this.registry = registry;
        this.metricsEndpoint = metricsEndpoint;
    }

    public PrometheusRequestHandlerImpl(PrometheusMeterRegistry registry) {
        this.registry = registry;
        this.metricsEndpoint = "/metrics";
    }

    public PrometheusRequestHandlerImpl() {
        this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.metricsEndpoint = "/metrics";
    }

    public void handle(HttpServerRequest request) {
        if (this.metricsEndpoint.equals(request.path())) {
            request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; version=0.0.4; charset=utf-8").end(this.registry.scrape());
        } else {
            request.response().setStatusCode(404).end();
        }
    }
}

