/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.netty4.NettyAllocatorMetrics;
import io.micrometer.core.instrument.binder.netty4.NettyEventExecutorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PooledByteBufAllocator;
import io.vertx.core.Vertx;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.buffer.BufferInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.VertxClientMetrics;
import io.vertx.micrometer.impl.VertxDatagramSocketMetrics;
import io.vertx.micrometer.impl.VertxEventBusMetrics;
import io.vertx.micrometer.impl.VertxHttpClientMetrics;
import io.vertx.micrometer.impl.VertxHttpServerMetrics;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.VertxNetServerMetrics;
import io.vertx.micrometer.impl.VertxPoolMetrics;
import io.vertx.micrometer.impl.meters.LongGauges;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class VertxMetricsImpl
extends AbstractMetrics
implements VertxMetrics {
    private final BackendRegistry backendRegistry;
    private final String registryName;
    private final Set<String> disabledCategories;
    private final boolean bindJvmMetrics;
    private final boolean bindNettyMetrics;
    private final List<MeterBinder> meterBinders;
    private final Function<HttpRequest, Iterable<Tag>> serverRequestTagsProvider;
    private final Function<HttpRequest, Iterable<Tag>> clientRequestTagsProvider;

    public VertxMetricsImpl(MicrometerMetricsOptions options, BackendRegistry backendRegistry, LongGauges longGauges) {
        super(backendRegistry.getMeterRegistry(), options.getMetricsNaming(), longGauges, EnumSet.copyOf(options.getLabels()));
        this.backendRegistry = backendRegistry;
        this.registryName = options.getRegistryName();
        this.disabledCategories = options.getDisabledMetricsCategories() != null ? new HashSet<String>(options.getDisabledMetricsCategories()) : Collections.emptySet();
        this.bindJvmMetrics = options.isJvmMetricsEnabled();
        this.bindNettyMetrics = options.isNettyMetricsEnabled();
        this.meterBinders = new CopyOnWriteArrayList<MeterBinder>();
        this.serverRequestTagsProvider = options.getServerRequestTagsProvider();
        this.clientRequestTagsProvider = options.getClientRequestTagsProvider();
    }

    public void init() {
        this.backendRegistry.init();
        if (this.bindJvmMetrics) {
            this.addMeterBinder((MeterBinder)new ClassLoaderMetrics());
            this.addMeterBinder((MeterBinder)new JvmCompilationMetrics());
            this.addMeterBinder((MeterBinder)new JvmGcMetrics());
            this.addMeterBinder((MeterBinder)new JvmHeapPressureMetrics());
            this.addMeterBinder((MeterBinder)new JvmInfoMetrics());
            this.addMeterBinder((MeterBinder)new JvmMemoryMetrics());
            this.addMeterBinder((MeterBinder)new JvmThreadMetrics());
            this.addMeterBinder((MeterBinder)new ProcessorMetrics());
            this.addMeterBinder((MeterBinder)new UptimeMetrics());
        }
        if (this.bindNettyMetrics) {
            ByteBufAllocator allocator = BufferInternal.buffer().getByteBuf().alloc();
            if (allocator instanceof ByteBufAllocatorMetricProvider) {
                this.addMeterBinder((MeterBinder)new NettyAllocatorMetrics((ByteBufAllocatorMetricProvider)allocator));
            }
            if ((allocator = PooledByteBufAllocator.DEFAULT) != null) {
                this.addMeterBinder((MeterBinder)new NettyAllocatorMetrics((ByteBufAllocatorMetricProvider)allocator));
            }
        }
    }

    private void addMeterBinder(MeterBinder meterBinder) {
        this.meterBinders.add(meterBinder);
        meterBinder.bindTo(this.registry);
    }

    public void vertxCreated(Vertx vertx) {
        if (this.bindNettyMetrics) {
            VertxInternal vi = (VertxInternal)vertx;
            this.addMeterBinder((MeterBinder)new NettyEventExecutorMetrics((Iterable)vi.acceptorEventLoopGroup()));
            this.addMeterBinder((MeterBinder)new NettyEventExecutorMetrics((Iterable)vi.eventLoopGroup()));
        }
    }

    public EventBusMetrics<?> createEventBusMetrics() {
        if (this.disabledCategories.contains(MetricsDomain.EVENT_BUS.toCategory())) {
            return null;
        }
        return new VertxEventBusMetrics(this);
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions httpClientOptions, SocketAddress socketAddress) {
        if (this.disabledCategories.contains(MetricsDomain.HTTP_SERVER.toCategory())) {
            return null;
        }
        return new VertxHttpServerMetrics((AbstractMetrics)this, this.serverRequestTagsProvider, socketAddress);
    }

    public HttpClientMetrics<?, ?, ?> createHttpClientMetrics(HttpClientOptions httpClientOptions) {
        if (this.disabledCategories.contains(MetricsDomain.HTTP_CLIENT.toCategory())) {
            return null;
        }
        return new VertxHttpClientMetrics((AbstractMetrics)this, this.clientRequestTagsProvider, httpClientOptions.getLocalAddress());
    }

    public TCPMetrics<?> createNetServerMetrics(NetServerOptions netServerOptions, SocketAddress socketAddress) {
        if (this.disabledCategories.contains(MetricsDomain.NET_SERVER.toCategory())) {
            return null;
        }
        return new VertxNetServerMetrics((AbstractMetrics)this, socketAddress);
    }

    public TCPMetrics<?> createNetClientMetrics(NetClientOptions netClientOptions) {
        if (this.disabledCategories.contains(MetricsDomain.NET_CLIENT.toCategory())) {
            return null;
        }
        return new VertxNetClientMetrics((AbstractMetrics)this, netClientOptions.getLocalAddress());
    }

    public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
        if (this.disabledCategories.contains(MetricsDomain.DATAGRAM_SOCKET.toCategory())) {
            return null;
        }
        return new VertxDatagramSocketMetrics(this);
    }

    public PoolMetrics<?, ?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
        if (this.disabledCategories.contains(MetricsDomain.NAMED_POOLS.toCategory())) {
            return null;
        }
        return new VertxPoolMetrics(this, poolType, poolName, maxPoolSize);
    }

    public ClientMetrics<?, ?, ?> createClientMetrics(SocketAddress remoteAddress, String type, String namespace) {
        if (this.disabledCategories.contains(type)) {
            return null;
        }
        return new VertxClientMetrics(this, remoteAddress, type, namespace);
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    public void close() {
        for (MeterBinder meterBinder : this.meterBinders) {
            if (!(meterBinder instanceof AutoCloseable)) continue;
            AutoCloseable closeable = (AutoCloseable)meterBinder;
            try {
                closeable.close();
            }
            catch (Exception exception) {}
        }
        BackendRegistries.stop(this.registryName);
    }
}

