/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import java.util.concurrent.atomic.LongAdder;

class VertxPoolMetrics
extends AbstractMetrics
implements PoolMetrics<Timer.Sample, Timer.Sample> {
    final Timer queueDelay;
    final LongAdder queueSize;
    final Timer usage;
    final LongAdder inUse;
    final LongAdder usageRatio;
    final Counter completed;

    VertxPoolMetrics(AbstractMetrics parent, String poolType, String poolName, int maxPoolSize) {
        super(parent, MetricsDomain.NAMED_POOLS);
        Tags tags = Tags.empty();
        if (this.enabledLabels.contains((Object)Label.POOL_TYPE) || "http".equals(poolType)) {
            tags = tags.and(Label.POOL_TYPE.toString(), poolType);
        }
        if (this.enabledLabels.contains((Object)Label.POOL_NAME) || "http".equals(poolType)) {
            tags = tags.and(Label.POOL_NAME.toString(), poolName);
        }
        this.queueDelay = Timer.builder((String)this.names.getPoolQueueTime()).description("Time spent in queue before being processed").tags((Iterable)tags).register(this.registry);
        this.queueSize = this.longGaugeBuilder(this.names.getPoolQueuePending(), LongAdder::doubleValue).description("Number of pending elements in queue").tags((Iterable<Tag>)tags).register(this.registry);
        this.usage = Timer.builder((String)this.names.getPoolUsage()).description("Time using a resource").tags((Iterable)tags).register(this.registry);
        this.inUse = this.longGaugeBuilder(this.names.getPoolInUse(), LongAdder::doubleValue).description("Number of resources used").tags((Iterable<Tag>)tags).register(this.registry);
        this.usageRatio = this.longGaugeBuilder(this.names.getPoolUsageRatio(), value -> maxPoolSize > 0 ? value.doubleValue() / (double)maxPoolSize : Double.NaN).description("Pool usage ratio, only present if maximum pool size could be determined").tags((Iterable<Tag>)tags).register(this.registry);
        this.completed = Counter.builder((String)this.names.getPoolCompleted()).description("Number of elements done with the resource").tags((Iterable)tags).register(this.registry);
    }

    public Timer.Sample enqueue() {
        this.queueSize.increment();
        return Timer.start();
    }

    public void dequeue(Timer.Sample submitted) {
        this.queueSize.decrement();
        submitted.stop(this.queueDelay);
    }

    public Timer.Sample begin() {
        this.inUse.increment();
        this.usageRatio.increment();
        return Timer.start();
    }

    public void end(Timer.Sample timer) {
        this.inUse.decrement();
        this.usageRatio.decrement();
        timer.stop(this.usage);
        this.completed.increment();
    }
}

