/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.openapi.validation.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.openapi.validation.ResponseParameter;
import io.vertx.openapi.validation.ValidatableResponse;
import io.vertx.openapi.validation.ValidatedResponse;
import io.vertx.openapi.validation.impl.RequestParameterImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ValidatedResponseImpl
implements ValidatedResponse {
    private final Map<String, ResponseParameter> headers;
    private final ResponseParameter body;
    private final ValidatableResponse unvalidated;

    public ValidatedResponseImpl(Map<String, ResponseParameter> headers, ResponseParameter body, ValidatableResponse unvalidated) {
        this.headers = ValidatedResponseImpl.safeUnmodifiableMap(headers);
        this.body = body == null ? new RequestParameterImpl(null) : body;
        this.unvalidated = unvalidated;
    }

    protected static Map<String, ResponseParameter> safeUnmodifiableMap(Map<String, ResponseParameter> map) {
        Map<String, ResponseParameter> lowerCaseHeader = Optional.ofNullable(map).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(), Map.Entry::getValue));
        return Collections.unmodifiableMap(map == null ? Collections.emptyMap() : new HashMap<String, ResponseParameter>(lowerCaseHeader){

            @Override
            public ResponseParameter get(Object key) {
                return (ResponseParameter)super.get(key.toString().toLowerCase());
            }

            @Override
            public boolean containsKey(Object key) {
                return this.get(key) != null;
            }
        });
    }

    @Override
    public Map<String, ResponseParameter> getHeaders() {
        return this.headers;
    }

    @Override
    public ResponseParameter getBody() {
        return this.body;
    }

    @Override
    public Future<Void> send(HttpServerResponse serverResponse) {
        serverResponse.setStatusCode(this.unvalidated.getStatusCode());
        for (String header : this.headers.keySet()) {
            ResponseParameter headerValue = this.unvalidated.getHeaders().get(header);
            if (headerValue == null) continue;
            serverResponse.headers().add(header, headerValue.getString());
        }
        if (this.body.isNull() || this.body.isString() && this.body.getString().isEmpty() || this.body.isBuffer() && this.body.getBuffer().length() == 0) {
            return serverResponse.send();
        }
        serverResponse.headers().add(HttpHeaders.CONTENT_TYPE.toString(), this.unvalidated.getContentType());
        return serverResponse.send(this.unvalidated.getBody().getBuffer());
    }
}

