/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisAPIImpl;
import java.util.List;

@VertxGen
public interface RedisAPI {
    @GenIgnore(value={"permitted-type"})
    public static RedisAPI api(Redis client) {
        return new RedisAPIImpl(client);
    }

    @GenIgnore(value={"permitted-type"})
    public static RedisAPI api(RedisConnection connection) {
        return new RedisAPIImpl(connection);
    }

    public void close();

    default public Future<@Nullable Response> ftAdd(List<String> args) {
        return this.send(Command.FT_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAggregate(List<String> args) {
        return this.send(Command.FT_AGGREGATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAliasadd(List<String> args) {
        return this.send(Command.FT_ALIASADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAliasdel(List<String> args) {
        return this.send(Command.FT_ALIASDEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAliasupdate(List<String> args) {
        return this.send(Command.FT_ALIASUPDATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAlter(List<String> args) {
        return this.send(Command.FT_ALTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftConfig(List<String> args) {
        return this.send(Command.FT_CONFIG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftCreate(List<String> args) {
        return this.send(Command.FT_CREATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftCursor(List<String> args) {
        return this.send(Command.FT_CURSOR, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDebug(List<String> args) {
        return this.send(Command.FT_DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDel(List<String> args) {
        return this.send(Command.FT_DEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDictadd(List<String> args) {
        return this.send(Command.FT_DICTADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDictdel(List<String> args) {
        return this.send(Command.FT_DICTDEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDictdump(List<String> args) {
        return this.send(Command.FT_DICTDUMP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDrop(List<String> args) {
        return this.send(Command.FT_DROP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDropindex(List<String> args) {
        return this.send(Command.FT_DROPINDEX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftExplain(List<String> args) {
        return this.send(Command.FT_EXPLAIN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftExplaincli(List<String> args) {
        return this.send(Command.FT_EXPLAINCLI, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftGet(List<String> args) {
        return this.send(Command.FT_GET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftInfo(List<String> args) {
        return this.send(Command.FT_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftMget(List<String> args) {
        return this.send(Command.FT_MGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftProfile(List<String> args) {
        return this.send(Command.FT_PROFILE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSafeadd(List<String> args) {
        return this.send(Command.FT_SAFEADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSearch(List<String> args) {
        return this.send(Command.FT_SEARCH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSpellcheck(List<String> args) {
        return this.send(Command.FT_SPELLCHECK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSugadd(List<String> args) {
        return this.send(Command.FT_SUGADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSugdel(List<String> args) {
        return this.send(Command.FT_SUGDEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSugget(List<String> args) {
        return this.send(Command.FT_SUGGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSuglen(List<String> args) {
        return this.send(Command.FT_SUGLEN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSynadd(List<String> args) {
        return this.send(Command.FT_SYNADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSyndump(List<String> args) {
        return this.send(Command.FT_SYNDUMP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftSynupdate(List<String> args) {
        return this.send(Command.FT_SYNUPDATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftTagvals(List<String> args) {
        return this.send(Command.FT_TAGVALS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAliasaddifnx(List<String> args) {
        return this.send(Command.FT__ALIASADDIFNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAliasdelifx(List<String> args) {
        return this.send(Command.FT__ALIASDELIFX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftAlterifnx(List<String> args) {
        return this.send(Command.FT__ALTERIFNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftCreateifnx(List<String> args) {
        return this.send(Command.FT__CREATEIFNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDropifx(List<String> args) {
        return this.send(Command.FT__DROPIFX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftDropindexifx(List<String> args) {
        return this.send(Command.FT__DROPINDEXIFX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ftList(List<String> args) {
        return this.send(Command.FT__LIST, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> acl(List<String> args) {
        return this.send(Command.ACL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> append(String arg0, String arg1) {
        return this.send(Command.APPEND, arg0, arg1);
    }

    default public Future<@Nullable Response> asking() {
        return this.send(Command.ASKING, new String[0]);
    }

    default public Future<@Nullable Response> auth(List<String> args) {
        return this.send(Command.AUTH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfAdd(List<String> args) {
        return this.send(Command.BF_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfCard(List<String> args) {
        return this.send(Command.BF_CARD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfDebug(List<String> args) {
        return this.send(Command.BF_DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfExists(List<String> args) {
        return this.send(Command.BF_EXISTS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfInfo(List<String> args) {
        return this.send(Command.BF_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfInsert(List<String> args) {
        return this.send(Command.BF_INSERT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfLoadchunk(List<String> args) {
        return this.send(Command.BF_LOADCHUNK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfMadd(List<String> args) {
        return this.send(Command.BF_MADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfMexists(List<String> args) {
        return this.send(Command.BF_MEXISTS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfReserve(List<String> args) {
        return this.send(Command.BF_RESERVE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bfScandump(List<String> args) {
        return this.send(Command.BF_SCANDUMP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bgrewriteaof() {
        return this.send(Command.BGREWRITEAOF, new String[0]);
    }

    default public Future<@Nullable Response> bgsave(List<String> args) {
        return this.send(Command.BGSAVE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bitcount(List<String> args) {
        return this.send(Command.BITCOUNT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bitfield(List<String> args) {
        return this.send(Command.BITFIELD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bitfieldRo(List<String> args) {
        return this.send(Command.BITFIELD_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bitop(List<String> args) {
        return this.send(Command.BITOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bitpos(List<String> args) {
        return this.send(Command.BITPOS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> blmove(String arg0, String arg1, String arg2, String arg3, String arg4) {
        return this.send(Command.BLMOVE, arg0, arg1, arg2, arg3, arg4);
    }

    default public Future<@Nullable Response> blmpop(List<String> args) {
        return this.send(Command.BLMPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> blpop(List<String> args) {
        return this.send(Command.BLPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> brpop(List<String> args) {
        return this.send(Command.BRPOP, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> brpoplpush(String arg0, String arg1, String arg2) {
        return this.send(Command.BRPOPLPUSH, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> bzmpop(List<String> args) {
        return this.send(Command.BZMPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bzpopmax(List<String> args) {
        return this.send(Command.BZPOPMAX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> bzpopmin(List<String> args) {
        return this.send(Command.BZPOPMIN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfAdd(List<String> args) {
        return this.send(Command.CF_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfAddnx(List<String> args) {
        return this.send(Command.CF_ADDNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfCompact(List<String> args) {
        return this.send(Command.CF_COMPACT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfCount(List<String> args) {
        return this.send(Command.CF_COUNT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfDebug(List<String> args) {
        return this.send(Command.CF_DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfDel(List<String> args) {
        return this.send(Command.CF_DEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfExists(List<String> args) {
        return this.send(Command.CF_EXISTS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfInfo(List<String> args) {
        return this.send(Command.CF_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfInsert(List<String> args) {
        return this.send(Command.CF_INSERT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfInsertnx(List<String> args) {
        return this.send(Command.CF_INSERTNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfLoadchunk(List<String> args) {
        return this.send(Command.CF_LOADCHUNK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfMexists(List<String> args) {
        return this.send(Command.CF_MEXISTS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfReserve(List<String> args) {
        return this.send(Command.CF_RESERVE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cfScandump(List<String> args) {
        return this.send(Command.CF_SCANDUMP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> client(List<String> args) {
        return this.send(Command.CLIENT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cluster(List<String> args) {
        return this.send(Command.CLUSTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsIncrby(List<String> args) {
        return this.send(Command.CMS_INCRBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsInfo(List<String> args) {
        return this.send(Command.CMS_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsInitbydim(List<String> args) {
        return this.send(Command.CMS_INITBYDIM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsInitbyprob(List<String> args) {
        return this.send(Command.CMS_INITBYPROB, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsMerge(List<String> args) {
        return this.send(Command.CMS_MERGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> cmsQuery(List<String> args) {
        return this.send(Command.CMS_QUERY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> command(List<String> args) {
        return this.send(Command.COMMAND, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> config(List<String> args) {
        return this.send(Command.CONFIG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> copy(List<String> args) {
        return this.send(Command.COPY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> dbsize() {
        return this.send(Command.DBSIZE, new String[0]);
    }

    default public Future<@Nullable Response> debug(List<String> args) {
        return this.send(Command.DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> decr(String arg0) {
        return this.send(Command.DECR, arg0);
    }

    default public Future<@Nullable Response> decrby(String arg0, String arg1) {
        return this.send(Command.DECRBY, arg0, arg1);
    }

    default public Future<@Nullable Response> del(List<String> args) {
        return this.send(Command.DEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> discard() {
        return this.send(Command.DISCARD, new String[0]);
    }

    default public Future<@Nullable Response> dump(String arg0) {
        return this.send(Command.DUMP, arg0);
    }

    default public Future<@Nullable Response> echo(String arg0) {
        return this.send(Command.ECHO, arg0);
    }

    default public Future<@Nullable Response> eval(List<String> args) {
        return this.send(Command.EVAL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> evalRo(List<String> args) {
        return this.send(Command.EVAL_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> evalsha(List<String> args) {
        return this.send(Command.EVALSHA, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> evalshaRo(List<String> args) {
        return this.send(Command.EVALSHA_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> exec() {
        return this.send(Command.EXEC, new String[0]);
    }

    default public Future<@Nullable Response> exists(List<String> args) {
        return this.send(Command.EXISTS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> expire(List<String> args) {
        return this.send(Command.EXPIRE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> expireat(List<String> args) {
        return this.send(Command.EXPIREAT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> expiretime(String arg0) {
        return this.send(Command.EXPIRETIME, arg0);
    }

    default public Future<@Nullable Response> failover(List<String> args) {
        return this.send(Command.FAILOVER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> fcall(List<String> args) {
        return this.send(Command.FCALL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> fcallRo(List<String> args) {
        return this.send(Command.FCALL_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> flushall(List<String> args) {
        return this.send(Command.FLUSHALL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> flushdb(List<String> args) {
        return this.send(Command.FLUSHDB, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> function(List<String> args) {
        return this.send(Command.FUNCTION, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geoadd(List<String> args) {
        return this.send(Command.GEOADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geodist(List<String> args) {
        return this.send(Command.GEODIST, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geohash(List<String> args) {
        return this.send(Command.GEOHASH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geopos(List<String> args) {
        return this.send(Command.GEOPOS, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> georadius(List<String> args) {
        return this.send(Command.GEORADIUS, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> georadiusRo(List<String> args) {
        return this.send(Command.GEORADIUS_RO, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> georadiusbymember(List<String> args) {
        return this.send(Command.GEORADIUSBYMEMBER, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> georadiusbymemberRo(List<String> args) {
        return this.send(Command.GEORADIUSBYMEMBER_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geosearch(List<String> args) {
        return this.send(Command.GEOSEARCH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> geosearchstore(List<String> args) {
        return this.send(Command.GEOSEARCHSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> get(String arg0) {
        return this.send(Command.GET, arg0);
    }

    default public Future<@Nullable Response> getbit(String arg0, String arg1) {
        return this.send(Command.GETBIT, arg0, arg1);
    }

    default public Future<@Nullable Response> getdel(String arg0) {
        return this.send(Command.GETDEL, arg0);
    }

    default public Future<@Nullable Response> getex(List<String> args) {
        return this.send(Command.GETEX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> getrange(String arg0, String arg1, String arg2) {
        return this.send(Command.GETRANGE, arg0, arg1, arg2);
    }

    @Deprecated
    default public Future<@Nullable Response> getset(String arg0, String arg1) {
        return this.send(Command.GETSET, arg0, arg1);
    }

    default public Future<@Nullable Response> graphBulk(List<String> args) {
        return this.send(Command.GRAPH_BULK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphConfig(List<String> args) {
        return this.send(Command.GRAPH_CONFIG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphDebug(List<String> args) {
        return this.send(Command.GRAPH_DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphDelete(List<String> args) {
        return this.send(Command.GRAPH_DELETE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphExplain(List<String> args) {
        return this.send(Command.GRAPH_EXPLAIN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphList(List<String> args) {
        return this.send(Command.GRAPH_LIST, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphProfile(List<String> args) {
        return this.send(Command.GRAPH_PROFILE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphQuery(List<String> args) {
        return this.send(Command.GRAPH_QUERY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphRoQuery(List<String> args) {
        return this.send(Command.GRAPH_RO_QUERY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> graphSlowlog(List<String> args) {
        return this.send(Command.GRAPH_SLOWLOG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hdel(List<String> args) {
        return this.send(Command.HDEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hello(List<String> args) {
        return this.send(Command.HELLO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hexists(String arg0, String arg1) {
        return this.send(Command.HEXISTS, arg0, arg1);
    }

    default public Future<@Nullable Response> hget(String arg0, String arg1) {
        return this.send(Command.HGET, arg0, arg1);
    }

    default public Future<@Nullable Response> hgetall(String arg0) {
        return this.send(Command.HGETALL, arg0);
    }

    default public Future<@Nullable Response> hincrby(String arg0, String arg1, String arg2) {
        return this.send(Command.HINCRBY, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> hincrbyfloat(String arg0, String arg1, String arg2) {
        return this.send(Command.HINCRBYFLOAT, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> hkeys(String arg0) {
        return this.send(Command.HKEYS, arg0);
    }

    default public Future<@Nullable Response> hlen(String arg0) {
        return this.send(Command.HLEN, arg0);
    }

    default public Future<@Nullable Response> hmget(List<String> args) {
        return this.send(Command.HMGET, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> hmset(List<String> args) {
        return this.send(Command.HMSET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hrandfield(List<String> args) {
        return this.send(Command.HRANDFIELD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hscan(List<String> args) {
        return this.send(Command.HSCAN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hset(List<String> args) {
        return this.send(Command.HSET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> hsetnx(String arg0, String arg1, String arg2) {
        return this.send(Command.HSETNX, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> hstrlen(String arg0, String arg1) {
        return this.send(Command.HSTRLEN, arg0, arg1);
    }

    default public Future<@Nullable Response> hvals(String arg0) {
        return this.send(Command.HVALS, arg0);
    }

    default public Future<@Nullable Response> incr(String arg0) {
        return this.send(Command.INCR, arg0);
    }

    default public Future<@Nullable Response> incrby(String arg0, String arg1) {
        return this.send(Command.INCRBY, arg0, arg1);
    }

    default public Future<@Nullable Response> incrbyfloat(String arg0, String arg1) {
        return this.send(Command.INCRBYFLOAT, arg0, arg1);
    }

    default public Future<@Nullable Response> info(List<String> args) {
        return this.send(Command.INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrappend(List<String> args) {
        return this.send(Command.JSON_ARRAPPEND, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrindex(List<String> args) {
        return this.send(Command.JSON_ARRINDEX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrinsert(List<String> args) {
        return this.send(Command.JSON_ARRINSERT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrlen(List<String> args) {
        return this.send(Command.JSON_ARRLEN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrpop(List<String> args) {
        return this.send(Command.JSON_ARRPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonArrtrim(List<String> args) {
        return this.send(Command.JSON_ARRTRIM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonClear(List<String> args) {
        return this.send(Command.JSON_CLEAR, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonDebug(List<String> args) {
        return this.send(Command.JSON_DEBUG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonDel(List<String> args) {
        return this.send(Command.JSON_DEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonForget(List<String> args) {
        return this.send(Command.JSON_FORGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonGet(List<String> args) {
        return this.send(Command.JSON_GET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonMget(List<String> args) {
        return this.send(Command.JSON_MGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonNumincrby(List<String> args) {
        return this.send(Command.JSON_NUMINCRBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonNummultby(List<String> args) {
        return this.send(Command.JSON_NUMMULTBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonNumpowby(List<String> args) {
        return this.send(Command.JSON_NUMPOWBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonObjkeys(List<String> args) {
        return this.send(Command.JSON_OBJKEYS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonObjlen(List<String> args) {
        return this.send(Command.JSON_OBJLEN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonResp(List<String> args) {
        return this.send(Command.JSON_RESP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonSet(List<String> args) {
        return this.send(Command.JSON_SET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonStrappend(List<String> args) {
        return this.send(Command.JSON_STRAPPEND, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonStrlen(List<String> args) {
        return this.send(Command.JSON_STRLEN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonToggle(List<String> args) {
        return this.send(Command.JSON_TOGGLE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> jsonType(List<String> args) {
        return this.send(Command.JSON_TYPE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> keys(String arg0) {
        return this.send(Command.KEYS, arg0);
    }

    default public Future<@Nullable Response> lastsave() {
        return this.send(Command.LASTSAVE, new String[0]);
    }

    default public Future<@Nullable Response> latency(List<String> args) {
        return this.send(Command.LATENCY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lcs(List<String> args) {
        return this.send(Command.LCS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lindex(String arg0, String arg1) {
        return this.send(Command.LINDEX, arg0, arg1);
    }

    default public Future<@Nullable Response> linsert(String arg0, String arg1, String arg2, String arg3) {
        return this.send(Command.LINSERT, arg0, arg1, arg2, arg3);
    }

    default public Future<@Nullable Response> llen(String arg0) {
        return this.send(Command.LLEN, arg0);
    }

    default public Future<@Nullable Response> lmove(String arg0, String arg1, String arg2, String arg3) {
        return this.send(Command.LMOVE, arg0, arg1, arg2, arg3);
    }

    default public Future<@Nullable Response> lmpop(List<String> args) {
        return this.send(Command.LMPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lolwut(List<String> args) {
        return this.send(Command.LOLWUT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lpop(List<String> args) {
        return this.send(Command.LPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lpos(List<String> args) {
        return this.send(Command.LPOS, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lpush(List<String> args) {
        return this.send(Command.LPUSH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lpushx(List<String> args) {
        return this.send(Command.LPUSHX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> lrange(String arg0, String arg1, String arg2) {
        return this.send(Command.LRANGE, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> lrem(String arg0, String arg1, String arg2) {
        return this.send(Command.LREM, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> lset(String arg0, String arg1, String arg2) {
        return this.send(Command.LSET, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> ltrim(String arg0, String arg1, String arg2) {
        return this.send(Command.LTRIM, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> memory(List<String> args) {
        return this.send(Command.MEMORY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> mget(List<String> args) {
        return this.send(Command.MGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> migrate(List<String> args) {
        return this.send(Command.MIGRATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> module(List<String> args) {
        return this.send(Command.MODULE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> monitor() {
        return this.send(Command.MONITOR, new String[0]);
    }

    default public Future<@Nullable Response> move(String arg0, String arg1) {
        return this.send(Command.MOVE, arg0, arg1);
    }

    default public Future<@Nullable Response> mset(List<String> args) {
        return this.send(Command.MSET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> msetnx(List<String> args) {
        return this.send(Command.MSETNX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> multi() {
        return this.send(Command.MULTI, new String[0]);
    }

    default public Future<@Nullable Response> object(List<String> args) {
        return this.send(Command.OBJECT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> persist(String arg0) {
        return this.send(Command.PERSIST, arg0);
    }

    default public Future<@Nullable Response> pexpire(List<String> args) {
        return this.send(Command.PEXPIRE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pexpireat(List<String> args) {
        return this.send(Command.PEXPIREAT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pexpiretime(String arg0) {
        return this.send(Command.PEXPIRETIME, arg0);
    }

    default public Future<@Nullable Response> pfadd(List<String> args) {
        return this.send(Command.PFADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pfcount(List<String> args) {
        return this.send(Command.PFCOUNT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pfdebug(String arg0, String arg1) {
        return this.send(Command.PFDEBUG, arg0, arg1);
    }

    default public Future<@Nullable Response> pfmerge(List<String> args) {
        return this.send(Command.PFMERGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pfselftest() {
        return this.send(Command.PFSELFTEST, new String[0]);
    }

    default public Future<@Nullable Response> ping(List<String> args) {
        return this.send(Command.PING, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> psetex(String arg0, String arg1, String arg2) {
        return this.send(Command.PSETEX, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> psubscribe(List<String> args) {
        return this.send(Command.PSUBSCRIBE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> psync(List<String> args) {
        return this.send(Command.PSYNC, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> pttl(String arg0) {
        return this.send(Command.PTTL, arg0);
    }

    default public Future<@Nullable Response> publish(String arg0, String arg1) {
        return this.send(Command.PUBLISH, arg0, arg1);
    }

    default public Future<@Nullable Response> pubsub(List<String> args) {
        return this.send(Command.PUBSUB, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> punsubscribe(List<String> args) {
        return this.send(Command.PUNSUBSCRIBE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> quit(List<String> args) {
        return this.send(Command.QUIT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> randomkey() {
        return this.send(Command.RANDOMKEY, new String[0]);
    }

    default public Future<@Nullable Response> readonly() {
        return this.send(Command.READONLY, new String[0]);
    }

    default public Future<@Nullable Response> readwrite() {
        return this.send(Command.READWRITE, new String[0]);
    }

    default public Future<@Nullable Response> rename(String arg0, String arg1) {
        return this.send(Command.RENAME, arg0, arg1);
    }

    default public Future<@Nullable Response> renamenx(String arg0, String arg1) {
        return this.send(Command.RENAMENX, arg0, arg1);
    }

    default public Future<@Nullable Response> replconf(List<String> args) {
        return this.send(Command.REPLCONF, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> replicaof(String arg0, String arg1) {
        return this.send(Command.REPLICAOF, arg0, arg1);
    }

    default public Future<@Nullable Response> reset() {
        return this.send(Command.RESET, new String[0]);
    }

    default public Future<@Nullable Response> restore(List<String> args) {
        return this.send(Command.RESTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> restoreAsking(List<String> args) {
        return this.send(Command.RESTORE_ASKING, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> role() {
        return this.send(Command.ROLE, new String[0]);
    }

    default public Future<@Nullable Response> rpop(List<String> args) {
        return this.send(Command.RPOP, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> rpoplpush(String arg0, String arg1) {
        return this.send(Command.RPOPLPUSH, arg0, arg1);
    }

    default public Future<@Nullable Response> rpush(List<String> args) {
        return this.send(Command.RPUSH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> rpushx(List<String> args) {
        return this.send(Command.RPUSHX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sadd(List<String> args) {
        return this.send(Command.SADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> save() {
        return this.send(Command.SAVE, new String[0]);
    }

    default public Future<@Nullable Response> scan(List<String> args) {
        return this.send(Command.SCAN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> scard(String arg0) {
        return this.send(Command.SCARD, arg0);
    }

    default public Future<@Nullable Response> script(List<String> args) {
        return this.send(Command.SCRIPT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sdiff(List<String> args) {
        return this.send(Command.SDIFF, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sdiffstore(List<String> args) {
        return this.send(Command.SDIFFSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> select(String arg0) {
        return this.send(Command.SELECT, arg0);
    }

    default public Future<@Nullable Response> set(List<String> args) {
        return this.send(Command.SET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> setbit(String arg0, String arg1, String arg2) {
        return this.send(Command.SETBIT, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> setex(String arg0, String arg1, String arg2) {
        return this.send(Command.SETEX, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> setnx(String arg0, String arg1) {
        return this.send(Command.SETNX, arg0, arg1);
    }

    default public Future<@Nullable Response> setrange(String arg0, String arg1, String arg2) {
        return this.send(Command.SETRANGE, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> shutdown(List<String> args) {
        return this.send(Command.SHUTDOWN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sinter(List<String> args) {
        return this.send(Command.SINTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sintercard(List<String> args) {
        return this.send(Command.SINTERCARD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sinterstore(List<String> args) {
        return this.send(Command.SINTERSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sismember(String arg0, String arg1) {
        return this.send(Command.SISMEMBER, arg0, arg1);
    }

    @Deprecated
    default public Future<@Nullable Response> slaveof(String arg0, String arg1) {
        return this.send(Command.SLAVEOF, arg0, arg1);
    }

    default public Future<@Nullable Response> slowlog(List<String> args) {
        return this.send(Command.SLOWLOG, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> smembers(String arg0) {
        return this.send(Command.SMEMBERS, arg0);
    }

    default public Future<@Nullable Response> smismember(List<String> args) {
        return this.send(Command.SMISMEMBER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> smove(String arg0, String arg1, String arg2) {
        return this.send(Command.SMOVE, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> sort(List<String> args) {
        return this.send(Command.SORT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sortRo(List<String> args) {
        return this.send(Command.SORT_RO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> spop(List<String> args) {
        return this.send(Command.SPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> spublish(String arg0, String arg1) {
        return this.send(Command.SPUBLISH, arg0, arg1);
    }

    default public Future<@Nullable Response> srandmember(List<String> args) {
        return this.send(Command.SRANDMEMBER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> srem(List<String> args) {
        return this.send(Command.SREM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sscan(List<String> args) {
        return this.send(Command.SSCAN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ssubscribe(List<String> args) {
        return this.send(Command.SSUBSCRIBE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> strlen(String arg0) {
        return this.send(Command.STRLEN, arg0);
    }

    default public Future<@Nullable Response> subscribe(List<String> args) {
        return this.send(Command.SUBSCRIBE, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> substr(String arg0, String arg1, String arg2) {
        return this.send(Command.SUBSTR, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> sunion(List<String> args) {
        return this.send(Command.SUNION, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sunionstore(List<String> args) {
        return this.send(Command.SUNIONSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> sunsubscribe(List<String> args) {
        return this.send(Command.SUNSUBSCRIBE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> swapdb(String arg0, String arg1) {
        return this.send(Command.SWAPDB, arg0, arg1);
    }

    default public Future<@Nullable Response> sync() {
        return this.send(Command.SYNC, new String[0]);
    }

    default public Future<@Nullable Response> tdigestAdd(List<String> args) {
        return this.send(Command.TDIGEST_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestByrank(List<String> args) {
        return this.send(Command.TDIGEST_BYRANK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestByrevrank(List<String> args) {
        return this.send(Command.TDIGEST_BYREVRANK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestCdf(List<String> args) {
        return this.send(Command.TDIGEST_CDF, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestCreate(List<String> args) {
        return this.send(Command.TDIGEST_CREATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestInfo(List<String> args) {
        return this.send(Command.TDIGEST_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestMax(List<String> args) {
        return this.send(Command.TDIGEST_MAX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestMerge(List<String> args) {
        return this.send(Command.TDIGEST_MERGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestMin(List<String> args) {
        return this.send(Command.TDIGEST_MIN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestQuantile(List<String> args) {
        return this.send(Command.TDIGEST_QUANTILE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestRank(List<String> args) {
        return this.send(Command.TDIGEST_RANK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestReset(List<String> args) {
        return this.send(Command.TDIGEST_RESET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestRevrank(List<String> args) {
        return this.send(Command.TDIGEST_REVRANK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tdigestTrimmedMean(List<String> args) {
        return this.send(Command.TDIGEST_TRIMMED_MEAN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> time() {
        return this.send(Command.TIME, new String[0]);
    }

    default public Future<@Nullable Response> timeseriesClusterset(List<String> args) {
        return this.send(Command.TIMESERIES_CLUSTERSET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesClustersetfromshard(List<String> args) {
        return this.send(Command.TIMESERIES_CLUSTERSETFROMSHARD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesHello(List<String> args) {
        return this.send(Command.TIMESERIES_HELLO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesInfocluster(List<String> args) {
        return this.send(Command.TIMESERIES_INFOCLUSTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesInnercommunication(List<String> args) {
        return this.send(Command.TIMESERIES_INNERCOMMUNICATION, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesNetworktest(List<String> args) {
        return this.send(Command.TIMESERIES_NETWORKTEST, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> timeseriesRefreshcluster(List<String> args) {
        return this.send(Command.TIMESERIES_REFRESHCLUSTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkAdd(List<String> args) {
        return this.send(Command.TOPK_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkCount(List<String> args) {
        return this.send(Command.TOPK_COUNT, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkIncrby(List<String> args) {
        return this.send(Command.TOPK_INCRBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkInfo(List<String> args) {
        return this.send(Command.TOPK_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkList(List<String> args) {
        return this.send(Command.TOPK_LIST, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkQuery(List<String> args) {
        return this.send(Command.TOPK_QUERY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> topkReserve(List<String> args) {
        return this.send(Command.TOPK_RESERVE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> touch(List<String> args) {
        return this.send(Command.TOUCH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsAdd(List<String> args) {
        return this.send(Command.TS_ADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsAlter(List<String> args) {
        return this.send(Command.TS_ALTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsCreate(List<String> args) {
        return this.send(Command.TS_CREATE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsCreaterule(List<String> args) {
        return this.send(Command.TS_CREATERULE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsDecrby(List<String> args) {
        return this.send(Command.TS_DECRBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsDel(List<String> args) {
        return this.send(Command.TS_DEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsDeleterule(List<String> args) {
        return this.send(Command.TS_DELETERULE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsGet(List<String> args) {
        return this.send(Command.TS_GET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsIncrby(List<String> args) {
        return this.send(Command.TS_INCRBY, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsInfo(List<String> args) {
        return this.send(Command.TS_INFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsMadd(List<String> args) {
        return this.send(Command.TS_MADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsMget(List<String> args) {
        return this.send(Command.TS_MGET, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsMrange(List<String> args) {
        return this.send(Command.TS_MRANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsMrevrange(List<String> args) {
        return this.send(Command.TS_MREVRANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsQueryindex(List<String> args) {
        return this.send(Command.TS_QUERYINDEX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsRange(List<String> args) {
        return this.send(Command.TS_RANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> tsRevrange(List<String> args) {
        return this.send(Command.TS_REVRANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> ttl(String arg0) {
        return this.send(Command.TTL, arg0);
    }

    default public Future<@Nullable Response> type(String arg0) {
        return this.send(Command.TYPE, arg0);
    }

    default public Future<@Nullable Response> unlink(List<String> args) {
        return this.send(Command.UNLINK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> unsubscribe(List<String> args) {
        return this.send(Command.UNSUBSCRIBE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> unwatch() {
        return this.send(Command.UNWATCH, new String[0]);
    }

    default public Future<@Nullable Response> wait(String arg0, String arg1) {
        return this.send(Command.WAIT, arg0, arg1);
    }

    default public Future<@Nullable Response> watch(List<String> args) {
        return this.send(Command.WATCH, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xack(List<String> args) {
        return this.send(Command.XACK, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xadd(List<String> args) {
        return this.send(Command.XADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xautoclaim(List<String> args) {
        return this.send(Command.XAUTOCLAIM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xclaim(List<String> args) {
        return this.send(Command.XCLAIM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xdel(List<String> args) {
        return this.send(Command.XDEL, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xgroup(List<String> args) {
        return this.send(Command.XGROUP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xinfo(List<String> args) {
        return this.send(Command.XINFO, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xlen(String arg0) {
        return this.send(Command.XLEN, arg0);
    }

    default public Future<@Nullable Response> xpending(List<String> args) {
        return this.send(Command.XPENDING, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xrange(List<String> args) {
        return this.send(Command.XRANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xread(List<String> args) {
        return this.send(Command.XREAD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xreadgroup(List<String> args) {
        return this.send(Command.XREADGROUP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xrevrange(List<String> args) {
        return this.send(Command.XREVRANGE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xsetid(List<String> args) {
        return this.send(Command.XSETID, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> xtrim(List<String> args) {
        return this.send(Command.XTRIM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zadd(List<String> args) {
        return this.send(Command.ZADD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zcard(String arg0) {
        return this.send(Command.ZCARD, arg0);
    }

    default public Future<@Nullable Response> zcount(String arg0, String arg1, String arg2) {
        return this.send(Command.ZCOUNT, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> zdiff(List<String> args) {
        return this.send(Command.ZDIFF, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zdiffstore(List<String> args) {
        return this.send(Command.ZDIFFSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zincrby(String arg0, String arg1, String arg2) {
        return this.send(Command.ZINCRBY, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> zinter(List<String> args) {
        return this.send(Command.ZINTER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zintercard(List<String> args) {
        return this.send(Command.ZINTERCARD, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zinterstore(List<String> args) {
        return this.send(Command.ZINTERSTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zlexcount(String arg0, String arg1, String arg2) {
        return this.send(Command.ZLEXCOUNT, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> zmpop(List<String> args) {
        return this.send(Command.ZMPOP, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zmscore(List<String> args) {
        return this.send(Command.ZMSCORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zpopmax(List<String> args) {
        return this.send(Command.ZPOPMAX, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zpopmin(List<String> args) {
        return this.send(Command.ZPOPMIN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zrandmember(List<String> args) {
        return this.send(Command.ZRANDMEMBER, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zrange(List<String> args) {
        return this.send(Command.ZRANGE, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> zrangebylex(List<String> args) {
        return this.send(Command.ZRANGEBYLEX, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> zrangebyscore(List<String> args) {
        return this.send(Command.ZRANGEBYSCORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zrangestore(List<String> args) {
        return this.send(Command.ZRANGESTORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zrank(String arg0, String arg1) {
        return this.send(Command.ZRANK, arg0, arg1);
    }

    default public Future<@Nullable Response> zrem(List<String> args) {
        return this.send(Command.ZREM, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zremrangebylex(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYLEX, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> zremrangebyrank(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYRANK, arg0, arg1, arg2);
    }

    default public Future<@Nullable Response> zremrangebyscore(String arg0, String arg1, String arg2) {
        return this.send(Command.ZREMRANGEBYSCORE, arg0, arg1, arg2);
    }

    @Deprecated
    default public Future<@Nullable Response> zrevrange(List<String> args) {
        return this.send(Command.ZREVRANGE, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> zrevrangebylex(List<String> args) {
        return this.send(Command.ZREVRANGEBYLEX, args.toArray(new String[0]));
    }

    @Deprecated
    default public Future<@Nullable Response> zrevrangebyscore(List<String> args) {
        return this.send(Command.ZREVRANGEBYSCORE, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zrevrank(String arg0, String arg1) {
        return this.send(Command.ZREVRANK, arg0, arg1);
    }

    default public Future<@Nullable Response> zscan(List<String> args) {
        return this.send(Command.ZSCAN, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zscore(String arg0, String arg1) {
        return this.send(Command.ZSCORE, arg0, arg1);
    }

    default public Future<@Nullable Response> zunion(List<String> args) {
        return this.send(Command.ZUNION, args.toArray(new String[0]));
    }

    default public Future<@Nullable Response> zunionstore(List<String> args) {
        return this.send(Command.ZUNIONSTORE, args.toArray(new String[0]));
    }

    @GenIgnore
    public Future<@Nullable Response> send(Command var1, String ... var2);
}

