/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.resource.ManagedResource;
import io.vertx.core.internal.resource.ResourceManager;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.RedisConnectionInternal;
import io.vertx.redis.client.impl.RedisStandaloneConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class RedisConnectionManager
implements Function<ConnectionKey, RedisEndpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnectionManager.class);
    private static final Handler<Throwable> DEFAULT_EXCEPTION_HANDLER = t -> LOG.error((Object)"Unhandled Error", t);
    private final VertxInternal vertx;
    private final NetClientInternal netClient;
    private final PoolMetrics metrics;
    private final NetClientOptions tcpOptions;
    private final PoolOptions poolOptions;
    private final Supplier<Future<RedisConnectOptions>> connectOptions;
    private final TracingPolicy tracingPolicy;
    private final ResourceManager<ConnectionKey, RedisEndpoint> pooledConnectionManager;
    private long timerID;

    RedisConnectionManager(VertxInternal vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, Supplier<Future<RedisConnectOptions>> connectOptions, TracingPolicy tracingPolicy) {
        this.vertx = vertx;
        this.tcpOptions = tcpOptions;
        this.poolOptions = poolOptions;
        this.connectOptions = connectOptions;
        this.tracingPolicy = tracingPolicy;
        VertxMetrics metricsSPI = this.vertx.metricsSPI();
        this.metrics = metricsSPI != null ? metricsSPI.createPoolMetrics("redis", poolOptions.getName(), poolOptions.getMaxSize()) : null;
        this.netClient = (NetClientInternal)vertx.createNetClient(tcpOptions);
        this.pooledConnectionManager = new ResourceManager();
    }

    private RedisEndpoint connectionEndpointProvider(String connectionString, Request setup) {
        return new RedisEndpoint(this.vertx, this.netClient, this.tcpOptions, this.poolOptions, this.connectOptions, this.tracingPolicy, connectionString, setup);
    }

    synchronized void start() {
        long period = this.poolOptions.getCleanerInterval();
        this.timerID = period > 0L ? this.vertx.setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private void checkExpired(long period) {
        this.pooledConnectionManager.forEach(e -> ((RedisEndpoint)e).pool.evict(conn -> !conn.isValid()).onSuccess(conns -> {
            for (RedisConnectionInternal conn : conns) {
                conn.handler((Handler)null);
                conn.endHandler((Handler)null);
                conn.exceptionHandler((Handler)null);
                conn.forceClose();
            }
        }));
        this.timerID = this.vertx.setTimer(period, id -> this.checkExpired(period));
    }

    @Override
    public RedisEndpoint apply(ConnectionKey key) {
        return this.connectionEndpointProvider(key.string, key.setup);
    }

    public Future<PooledRedisConnection> getConnection(String connectionString, Request setup) {
        ContextInternal context = this.vertx.getOrCreateContext();
        ContextInternal eventLoopContext = context.isEventLoopContext() ? context : this.vertx.createEventLoopContext(context.nettyEventLoop(), context.workerPool(), context.classLoader());
        boolean metricsEnabled = this.metrics != null;
        Object queueMetric = metricsEnabled ? this.metrics.enqueue() : null;
        Future future = this.pooledConnectionManager.withResourceAsync((Object)new ConnectionKey(connectionString, setup), (Function)this, (endpoint, created) -> endpoint.requestConnection(eventLoopContext));
        return future.andThen(ar -> {
            if (metricsEnabled) {
                this.metrics.dequeue(queueMetric);
            }
        }).map(lease -> new PooledRedisConnection((Lease<RedisConnectionInternal>)lease, this.metrics, metricsEnabled ? this.metrics.begin() : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> close() {
        RedisConnectionManager redisConnectionManager = this;
        synchronized (redisConnectionManager) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.pooledConnectionManager.close();
        Future fut = this.netClient.close();
        if (this.metrics != null) {
            this.metrics.close();
        }
        return fut;
    }

    public static class RedisEndpoint
    extends ManagedResource {
        final ConnectionPool<RedisConnectionInternal> pool;

        public ConnectionPool<RedisConnectionInternal> pool() {
            return this.pool;
        }

        public RedisEndpoint(VertxInternal vertx, NetClientInternal netClient, NetClientOptions netClientOptions, PoolOptions poolOptions, Supplier<Future<RedisConnectOptions>> connectOptions, TracingPolicy tracingPolicy, String connectionString, Request setup) {
            RedisConnectionProvider connector = new RedisConnectionProvider(vertx, netClient, netClientOptions, poolOptions, connectOptions, tracingPolicy, connectionString, setup);
            this.pool = ConnectionPool.pool((PoolConnector)connector, (int[])new int[]{poolOptions.getMaxSize()}, (int)poolOptions.getMaxWaiting());
        }

        public Future<Lease<RedisConnectionInternal>> requestConnection(ContextInternal ctx) {
            PromiseInternal promise = ctx.promise();
            this.pool.acquire(ctx, 0).onSuccess(arg_0 -> this.lambda$requestConnection$0((Promise)promise, arg_0)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
            return promise.future();
        }

        private /* synthetic */ void lambda$requestConnection$0(Promise promise, Lease lease) {
            this.incRefCount();
            ((RedisStandaloneConnection)lease.get()).evictHandler(() -> ((RedisEndpoint)this).decRefCount());
            promise.succeed((Object)lease);
        }
    }

    static class RedisConnectionProvider
    implements PoolConnector<RedisConnectionInternal> {
        private final VertxInternal vertx;
        private final NetClientInternal netClient;
        private final RedisURI redisURI;
        private final Request setup;
        private final NetClientOptions netClientOptions;
        private final PoolOptions poolOptions;
        private final Supplier<Future<RedisConnectOptions>> options;
        private final TracingPolicy tracingPolicy;

        public RedisConnectionProvider(VertxInternal vertx, NetClientInternal netClient, NetClientOptions netClientOptions, PoolOptions poolOptions, Supplier<Future<RedisConnectOptions>> options, TracingPolicy tracingPolicy, String connectionString, Request setup) {
            this.vertx = vertx;
            this.netClient = netClient;
            this.netClientOptions = netClientOptions;
            this.poolOptions = poolOptions;
            this.options = options;
            this.tracingPolicy = tracingPolicy;
            this.redisURI = new RedisURI(connectionString);
            this.setup = setup;
        }

        public boolean isValid(RedisConnectionInternal conn) {
            return conn.isValid();
        }

        public Future<ConnectResult<RedisConnectionInternal>> connect(ContextInternal ctx, PoolConnector.Listener listener) {
            boolean netClientSsl = this.netClientOptions.isSsl();
            boolean connectionStringSsl = this.redisURI.ssl();
            boolean connectionStringInetSocket = this.redisURI.socketAddress().isInetSocket();
            if (connectionStringInetSocket && netClientSsl && !connectionStringSsl) {
                return ctx.failedFuture("Pool initialized with SSL but connection requested plain socket");
            }
            return this.getConnectOptions(ctx, listener, connectionStringInetSocket, connectionStringSsl, netClientSsl);
        }

        private Future<ConnectResult<RedisConnectionInternal>> getConnectOptions(ContextInternal ctx, PoolConnector.Listener listener, boolean connectionStringInetSocket, boolean connectionStringSsl, boolean netClientSsl) {
            return this.options.get().compose(opts -> this.connectAndSetup(ctx, (RedisConnectOptions)opts, listener, connectionStringInetSocket, connectionStringSsl, netClientSsl));
        }

        private Future<ConnectResult<RedisConnectionInternal>> connectAndSetup(ContextInternal ctx, RedisConnectOptions options, PoolConnector.Listener listener, boolean connectionStringInetSocket, boolean connectionStringSsl, boolean netClientSsl) {
            try {
                ConnectOptions connectOptions = new ConnectOptions().setRemoteAddress(this.redisURI.socketAddress()).setSsl(this.netClientOptions.isSsl()).setSslOptions(this.netClientOptions.getSslOptions());
                PromiseInternal promise = ctx.promise();
                this.netClient.connectInternal(connectOptions, (Promise)promise, ctx);
                return promise.future().compose(so -> {
                    if (connectionStringInetSocket && !netClientSsl && connectionStringSsl) {
                        return so.upgradeToSsl().compose(v -> this.init(ctx, options, (NetSocket)so, listener));
                    }
                    return this.init(ctx, options, (NetSocket)so, listener);
                });
            }
            catch (RuntimeException err) {
                return ctx.failedFuture((Throwable)err);
            }
        }

        private Future<ConnectResult<RedisConnectionInternal>> init(ContextInternal ctx, RedisConnectOptions options, NetSocket netSocket, PoolConnector.Listener connectionListener) {
            VertxMetrics vertxMetrics = this.vertx.metricsSPI();
            ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(this.redisURI.socketAddress(), "redis", this.netClientOptions.getMetricsName()) : null;
            RedisStandaloneConnection connection = new RedisStandaloneConnection(this.vertx, ctx, connectionListener, netSocket, this.poolOptions, options.getMaxWaitingHandlers(), this.redisURI, metrics, this.tracingPolicy);
            connection.exceptionHandler((Handler)DEFAULT_EXCEPTION_HANDLER);
            netSocket.handler((Handler)new RESPParser(connection, options.getMaxNestedArrays())).closeHandler(connection::end).exceptionHandler(connection::fail);
            return this.hello(ctx, connection, this.redisURI, options).compose(hello -> this.select(ctx, connection, this.redisURI.select())).compose(select -> this.setup(ctx, connection, this.setup)).map(setup -> {
                connection.setValid();
                return new ConnectResult((Object)connection, 1L, 0L);
            });
        }

        private Future<Void> hello(ContextInternal ctx, RedisConnection connection, RedisURI redisURI, RedisConnectOptions options) {
            String client;
            String user;
            if (!options.isProtocolNegotiation()) {
                return this.ping(ctx, connection, options);
            }
            String version = "3";
            if (redisURI.param("protocol") != null) {
                version = redisURI.param("protocol");
            } else if (options.getPreferredProtocolVersion() != null) {
                version = options.getPreferredProtocolVersion().getValue();
            }
            Request hello = Request.cmd(Command.HELLO).arg(version);
            String password = redisURI.password() != null ? redisURI.password() : options.getPassword();
            String string = user = redisURI.user() != null ? redisURI.user() : options.getUser();
            if (password != null) {
                hello.arg("AUTH").arg(user == null ? "default" : user).arg(password);
            }
            if ((client = redisURI.param("client")) != null) {
                hello.arg("SETNAME").arg(client);
            }
            return connection.send(hello).mapEmpty().transform(ar -> {
                if (ar.failed()) {
                    Throwable err = ar.cause();
                    if (err instanceof ErrorType) {
                        String msg;
                        ErrorType redisErr = (ErrorType)err;
                        if (redisErr.is("NOAUTH")) {
                            return this.authenticate(ctx, connection, user, password);
                        }
                        if (redisErr.is("ERR") && ((msg = redisErr.getMessage()).startsWith("ERR unknown command") || msg.startsWith("ERR unknown or unsupported command"))) {
                            return this.ping(ctx, connection, options);
                        }
                    }
                } else {
                    LOG.debug(ar.result());
                }
                return (Future)ar;
            });
        }

        private Future<Void> ping(ContextInternal ctx, RedisConnection connection, RedisConnectOptions options) {
            Request ping = Request.cmd(Command.PING);
            return connection.send(ping).onSuccess(arg_0 -> ((Logger)LOG).debug(arg_0)).transform(ar -> {
                Throwable err;
                if (ar.failed() && (err = ar.cause()) instanceof ErrorType && ((ErrorType)err).is("NOAUTH")) {
                    String password = this.redisURI.password() != null ? this.redisURI.password() : options.getPassword();
                    String user = this.redisURI.user() != null ? this.redisURI.user() : options.getUser();
                    return this.authenticate(ctx, connection, user, password);
                }
                return ((Future)ar).mapEmpty();
            });
        }

        private Future<Void> authenticate(ContextInternal ctx, RedisConnection connection, String user, String password) {
            if (password == null) {
                return ctx.succeededFuture();
            }
            Request cmd = Request.cmd(Command.AUTH);
            if (user != null) {
                cmd.arg(user);
            }
            cmd.arg(password);
            return connection.send(cmd).mapEmpty();
        }

        private Future<Void> select(ContextInternal ctx, RedisConnection connection, Integer select) {
            if (select == null) {
                return ctx.succeededFuture();
            }
            return connection.send(Request.cmd(Command.SELECT).arg(select)).mapEmpty();
        }

        private Future<Void> setup(ContextInternal ctx, RedisConnection connection, Request setup) {
            if (setup == null) {
                return ctx.succeededFuture();
            }
            return connection.send(setup).mapEmpty();
        }
    }

    public static class ConnectionKey {
        private final String string;
        private final Request setup;

        ConnectionKey(String string, Request setup) {
            this.string = string;
            this.setup = setup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            return Objects.equals(this.string, that.string) && Objects.equals(this.setup, that.setup);
        }

        public int hashCode() {
            return Objects.hash(this.string, this.setup);
        }
    }
}

