/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisConnectException;
import io.vertx.redis.client.impl.RedisConnectionManager;
import io.vertx.redis.client.impl.Slots;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class SharedSlots {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSlots.class);
    private final Vertx vertx;
    private final Supplier<Future<RedisClusterConnectOptions>> connectOptions;
    private final RedisConnectionManager connectionManager;
    private final AtomicReference<Future<Slots>> slots = new AtomicReference();

    SharedSlots(Vertx vertx, Supplier<Future<RedisClusterConnectOptions>> connectOptions, RedisConnectionManager connectionManager) {
        this.vertx = vertx;
        this.connectOptions = connectOptions;
        this.connectionManager = connectionManager;
    }

    Future<Slots> get() {
        Promise promise;
        Future future;
        do {
            Future<Slots> slots;
            if ((slots = this.slots.get()) == null) continue;
            return slots;
        } while (!this.slots.compareAndSet(null, (Future<Slots>)(future = (promise = Promise.promise()).future())));
        LOG.debug((Object)"Obtaining hash slot assignment");
        this.connectOptions.get().onSuccess(opts -> this.getSlots((RedisClusterConnectOptions)opts, 0, ConcurrentHashMap.newKeySet(), (Completable<Slots>)promise)).onFailure(arg_0 -> ((Promise)promise).fail(arg_0));
        return future;
    }

    private void getSlots(RedisClusterConnectOptions connectOptions, int index, Set<Throwable> failures, Completable<Slots> onGotSlots) {
        List<String> endpoints = connectOptions.getEndpoints();
        if (index >= endpoints.size()) {
            StringBuilder message = new StringBuilder("Cannot connect to any of the provided endpoints");
            for (Throwable failure : failures) {
                message.append("\n- ").append(failure);
            }
            onGotSlots.fail((Throwable)new RedisConnectException(message.toString()));
            this.scheduleInvalidation(connectOptions);
            return;
        }
        this.connectionManager.getConnection(endpoints.get(index), RedisReplicas.NEVER != connectOptions.getUseReplicas() ? Request.cmd(Command.READONLY) : null).onFailure(err -> {
            failures.add((Throwable)err);
            this.getSlots(connectOptions, index + 1, failures, onGotSlots);
        }).onSuccess(conn -> this.getSlots((String)endpoints.get(index), (RedisConnection)conn).onComplete(result -> {
            conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
            if (result.failed()) {
                failures.add(result.cause());
                this.getSlots(connectOptions, index + 1, failures, onGotSlots);
            } else {
                Slots slots = (Slots)result.result();
                onGotSlots.succeed((Object)slots);
                this.scheduleInvalidation(connectOptions);
            }
        }));
    }

    private Future<Slots> getSlots(String endpoint, RedisConnection conn) {
        return conn.send(Request.cmd(Command.CLUSTER).arg("SLOTS")).compose(reply -> {
            Slots result;
            if (reply == null || reply.size() == 0) {
                return Future.failedFuture((String)"CLUSTER SLOTS No slots available in the cluster.");
            }
            try {
                result = new Slots(endpoint, (Response)reply);
            }
            catch (Exception e) {
                return Future.failedFuture((String)("CLUSTER SLOTS response invalid: " + e));
            }
            return Future.succeededFuture((Object)result);
        });
    }

    void invalidate() {
        this.slots.set(null);
    }

    private void scheduleInvalidation(RedisClusterConnectOptions connectOptions) {
        this.vertx.setTimer(connectOptions.getHashSlotCacheTTL(), ignored -> this.invalidate());
    }
}

