/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.http.HttpServerRequestInternal;
import io.vertx.core.internal.net.RFC3986;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.UserContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.impl.HandlersList;
import io.vertx.ext.web.impl.HeaderParser;
import io.vertx.ext.web.impl.HttpServerRequestWrapper;
import io.vertx.ext.web.impl.ParsableHeaderValue;
import io.vertx.ext.web.impl.ParsableHeaderValuesContainer;
import io.vertx.ext.web.impl.ParsableLanguageValue;
import io.vertx.ext.web.impl.ParsableMIMEValue;
import io.vertx.ext.web.impl.RequestBodyImpl;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.impl.UserContextImpl;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class RoutingContextImpl
extends RoutingContextImplBase {
    private final RouterImpl router;
    private final HttpServerRequest request;
    private final RequestBodyImpl body;
    private Map<String, Object> data;
    private Map<String, String> pathParams;
    private MultiMap queryParams;
    private HandlersList<Void> headersEndHandlers;
    private HandlersList<Void> bodyEndHandlers;
    private HandlersList<AsyncResult<Void>> endHandlers;
    private Throwable failure;
    private int statusCode = -1;
    private String normalizedPath;
    private String acceptableContentType;
    private ParsableHeaderValuesContainer parsedHeaders;
    private final AtomicBoolean cleanup = new AtomicBoolean(false);
    private List<FileUpload> fileUploads;
    private Session session;
    private UserContext identity;
    private volatile boolean isSessionAccessed = false;
    private volatile boolean endHandlerCalled = false;
    private static final String DEFAULT_404 = "<html><body><h1>Resource not found</h1></body></html>";

    public RoutingContextImpl(String mountPoint, RouterImpl router, HttpServerRequest request, Set<RouteImpl> routes) {
        super(mountPoint, routes, router);
        this.router = router;
        this.request = new HttpServerRequestWrapper(request, router.getAllowForward(), this);
        this.body = new RequestBodyImpl(this);
    }

    void route() {
        String path = this.request.path();
        boolean hasValidAuthority = ((HttpServerRequestInternal)this.request).isValidAuthority();
        if (!hasValidAuthority && this.request.version() != HttpVersion.HTTP_1_0) {
            String message = HttpVersion.HTTP_1_1 == this.request.version() ? "For HTTP/1.x requests, the 'Host' header is required" : "For HTTP/2 requests, the ':authority' pseudo-header is required";
            this.fail(400, (Throwable)new VertxException(message, true));
            return;
        }
        if (path == null || path.isEmpty()) {
            this.fail(400, (Throwable)new VertxException("The request path must start with '/' and cannot be empty", true));
            return;
        }
        if (path.charAt(0) != '/') {
            this.fail(404);
        } else {
            this.next();
        }
    }

    private String ensureNotNull(String string) {
        return string == null ? "" : string;
    }

    private void fillParsedHeaders(HttpServerRequest request) {
        String accept = request.getHeader(HttpHeaders.ACCEPT);
        String acceptCharset = request.getHeader(HttpHeaders.ACCEPT_CHARSET);
        String acceptEncoding = request.getHeader(HttpHeaders.ACCEPT_ENCODING);
        String acceptLanguage = request.getHeader(HttpHeaders.ACCEPT_LANGUAGE);
        String contentType = this.ensureNotNull(request.getHeader(HttpHeaders.CONTENT_TYPE));
        this.parsedHeaders = new ParsableHeaderValuesContainer(HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(accept, ParsableMIMEValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptCharset, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptEncoding, ParsableHeaderValue::new)), HeaderParser.sort(HeaderParser.convertToParsedHeaderValues(acceptLanguage, ParsableLanguageValue::new)), new ParsableMIMEValue(contentType));
    }

    @Override
    public HttpServerRequest request() {
        return this.request;
    }

    @Override
    public HttpServerResponse response() {
        return this.request.response();
    }

    @Override
    public Throwable failure() {
        return this.failure;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public boolean failed() {
        return this.failure != null || this.statusCode != -1;
    }

    @Override
    public void next() {
        if (!this.iterateNext()) {
            this.checkHandleNoMatch();
        }
    }

    private void checkHandleNoMatch() {
        if (this.failed()) {
            this.unhandledFailure(this.statusCode, this.failure, this.router);
        } else {
            Handler<RoutingContext> handler = this.router.getErrorHandlerByStatusCode(this.matchFailure);
            this.statusCode = this.matchFailure;
            if (handler == null) {
                this.response().setStatusCode(this.matchFailure);
                if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 404) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8").end(DEFAULT_404);
                } else if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 405) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.ALLOW, (CharSequence)this.allowedMethods.stream().map(HttpMethod::name).collect(Collectors.joining(","))).end();
                } else if (this.request().method() != HttpMethod.HEAD && this.matchFailure == 415) {
                    this.response().putHeader((CharSequence)HttpHeaderNames.ACCEPT, (CharSequence)this.allowedContentTypes.stream().map(MIMEHeader::mediaTypeWithParams).collect(Collectors.joining(", "))).end();
                } else {
                    this.response().end();
                }
            } else {
                handler.handle((Object)this);
            }
        }
    }

    @Override
    public void fail(int statusCode) {
        this.statusCode = statusCode;
        this.doFail();
    }

    @Override
    public void fail(Throwable t) {
        if (t instanceof HttpException) {
            this.fail(((HttpException)t).getStatusCode(), t);
        } else {
            this.fail(500, t);
        }
    }

    @Override
    public void fail(int statusCode, Throwable throwable) {
        this.statusCode = statusCode;
        Throwable throwable2 = this.failure = throwable == null ? new NullPointerException() : throwable;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RoutingContext failure (" + statusCode + ")"), this.failure);
        }
        this.doFail();
    }

    @Override
    public RoutingContext put(String key, Object obj) {
        this.getData().put(key, obj);
        return this;
    }

    @Override
    public Vertx vertx() {
        return this.router.vertx();
    }

    @Override
    public @Nullable RoutingContextInternal parent() {
        return null;
    }

    @Override
    public <T> T get(String key) {
        if (this.data == null) {
            return null;
        }
        return (T)this.getData().get(key);
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        if (this.data == null) {
            return defaultValue;
        }
        Map<String, Object> data = this.getData();
        if (data.containsKey(key)) {
            return (T)data.get(key);
        }
        return defaultValue;
    }

    @Override
    public <T> T remove(String key) {
        if (this.data == null) {
            return null;
        }
        return (T)this.getData().remove(key);
    }

    public Map<String, Object> data() {
        return this.getData();
    }

    @Override
    public String normalizedPath() {
        if (this.normalizedPath == null) {
            String path = this.request.path();
            this.normalizedPath = path == null ? "/" : RFC3986.normalizePath((String)path);
        }
        return this.normalizedPath;
    }

    @Override
    public RequestBody body() {
        return this.body;
    }

    @Override
    public void setBody(Buffer body) {
        this.body.setBuffer(body);
    }

    @Override
    public List<FileUpload> fileUploads() {
        if (this.fileUploads == null) {
            this.fileUploads = new ArrayList<FileUpload>();
        }
        return this.fileUploads;
    }

    @Override
    public void cancelAndCleanupFileUploads() {
        if (this.cleanup.compareAndSet(false, true)) {
            for (FileUpload fileUpload : this.fileUploads()) {
                if (fileUpload.cancel()) continue;
                Future<Void> future = fileUpload.delete();
                if (!LOG.isTraceEnabled()) continue;
                future.onFailure(err -> LOG.trace((Object)"Delete of uploaded file failed", err));
            }
        }
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
        UserHolder holder = (UserHolder)session.get("__vertx.userHolder");
        if (holder != null) {
            holder.refresh(this);
        }
    }

    @Override
    public Session session() {
        this.isSessionAccessed = true;
        return this.session;
    }

    @Override
    public boolean isSessionAccessed() {
        return this.isSessionAccessed;
    }

    @Override
    public UserContext user() {
        if (this.identity == null) {
            this.identity = new UserContextImpl(this);
        }
        return this.identity;
    }

    @Override
    public String getAcceptableContentType() {
        return this.acceptableContentType;
    }

    @Override
    public void setAcceptableContentType(String contentType) {
        this.acceptableContentType = contentType;
    }

    @Override
    public ParsableHeaderValuesContainer parsedHeaders() {
        if (this.parsedHeaders == null) {
            this.fillParsedHeaders(this.request);
        }
        return this.parsedHeaders;
    }

    @Override
    public int addHeadersEndHandler(Handler<Void> handler) {
        return this.getHeadersEndHandlers().put(handler);
    }

    @Override
    public boolean removeHeadersEndHandler(int handlerID) {
        return this.getHeadersEndHandlers().remove(handlerID);
    }

    @Override
    public int addBodyEndHandler(Handler<Void> handler) {
        return this.getBodyEndHandlers().put(handler);
    }

    @Override
    public boolean removeBodyEndHandler(int handlerID) {
        return this.getBodyEndHandlers().remove(handlerID);
    }

    @Override
    public int addEndHandler(Handler<AsyncResult<Void>> handler) {
        return this.getEndHandlers().put(handler);
    }

    @Override
    public boolean removeEndHandler(int handlerID) {
        return this.getEndHandlers().remove(handlerID);
    }

    @Override
    public void reroute(HttpMethod method, String path) {
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must start with '/'");
        }
        ((HttpServerRequestWrapper)this.request).changeTo(method, path);
        this.normalizedPath = null;
        this.statusCode = -1;
        this.response().headers().clear();
        if (this.headersEndHandlers != null) {
            this.headersEndHandlers.clear();
        }
        if (this.bodyEndHandlers != null) {
            this.bodyEndHandlers.clear();
        }
        this.failure = null;
        this.restart();
    }

    @Override
    public Map<String, String> pathParams() {
        return this.getPathParams();
    }

    @Override
    public @Nullable String pathParam(String name) {
        return this.getPathParams().get(name);
    }

    @Override
    public MultiMap queryParams() {
        return this.getQueryParams(null);
    }

    @Override
    public MultiMap queryParams(Charset charset) {
        return this.getQueryParams(charset);
    }

    @Override
    public @Nullable List<String> queryParam(String query) {
        return this.queryParams().getAll(query);
    }

    private MultiMap getQueryParams(Charset charset) {
        block6: {
            if (charset != null || this.queryParams == null) {
                try {
                    if (charset == null) {
                        this.queryParams = MultiMap.caseInsensitiveMultiMap();
                        Map decodedParams = new QueryStringDecoder(this.request.uri()).parameters();
                        for (Map.Entry entry : decodedParams.entrySet()) {
                            this.queryParams.add((String)entry.getKey(), (Iterable)entry.getValue());
                        }
                        break block6;
                    }
                    MultiMap queryParams = MultiMap.caseInsensitiveMultiMap();
                    Map decodedParams = new QueryStringDecoder(this.request.uri(), charset).parameters();
                    for (Map.Entry entry : decodedParams.entrySet()) {
                        queryParams.add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                    return queryParams;
                }
                catch (IllegalArgumentException e) {
                    throw new HttpException(400, "Error while decoding query params", e);
                }
            }
        }
        return this.queryParams;
    }

    private Map<String, String> getPathParams() {
        if (this.pathParams == null) {
            this.pathParams = new HashMap<String, String>();
        }
        return this.pathParams;
    }

    private HandlersList<Void> getHeadersEndHandlers() {
        if (this.headersEndHandlers == null) {
            this.headersEndHandlers = new HandlersList();
            this.response().headersEndHandler(v -> this.headersEndHandlers.invokeInReverseOrder(null));
        }
        return this.headersEndHandlers;
    }

    private HandlersList<Void> getBodyEndHandlers() {
        if (this.bodyEndHandlers == null) {
            this.bodyEndHandlers = new HandlersList();
            this.response().bodyEndHandler(v -> this.bodyEndHandlers.invokeInReverseOrder(null));
        }
        return this.bodyEndHandlers;
    }

    private HandlersList<AsyncResult<Void>> getEndHandlers() {
        if (this.endHandlers == null) {
            this.endHandlers = new HandlersList();
            ContextInternal ctx = (ContextInternal)this.vertx().getOrCreateContext();
            Handler endHandler = v -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.invokeInReverseOrder((AsyncResult<Void>)ctx.succeededFuture());
                }
            };
            Handler exceptionHandler = cause -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.invokeInReverseOrder((AsyncResult<Void>)ctx.failedFuture(cause));
                }
            };
            Handler closeHandler = cause -> {
                if (!this.endHandlerCalled) {
                    this.endHandlerCalled = true;
                    this.endHandlers.invokeInReverseOrder((AsyncResult<Void>)ctx.failedFuture("Connection closed"));
                }
            };
            this.response().endHandler(endHandler).exceptionHandler(exceptionHandler).closeHandler(closeHandler);
        }
        return this.endHandlers;
    }

    private void doFail() {
        this.iter = this.router.iterator();
        this.currentRoute = null;
        this.next();
    }

    private Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }
}

