/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Stroke;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.BaseSeriesMarkers;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.theme.GGPlot2Theme;
import org.knowm.xchart.style.theme.MatlabTheme;
import org.knowm.xchart.style.theme.Theme;
import org.knowm.xchart.style.theme.XChartTheme;

public class ChartStylePanel
extends JPanel {
    private EditorTable table;
    private XChartPanel chartPanel;
    static HashSet<String> skipSet = new HashSet<String>(Arrays.asList("class", "styler", "toolTips", "height", "width", "seriesMap", "YAxisGroupTitle", "XMax", "XMin", "YMax", "YMin", "extraValues", "XData", "YData", "xAxisDataType", "yAxisDataType", "legendRenderType", "name", "YAxisAlignment", "YAxisGroupPosition"));

    public ChartStylePanel(XChartPanel chartPanel) {
        this.chartPanel = chartPanel;
        this.table = new EditorTable(this, chartPanel.getChart());
        JScrollPane scrollpane = new JScrollPane(this.table);
        GridLayout layout = new GridLayout(1, 1);
        this.setLayout(layout);
        this.add(scrollpane);
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void changeChart(XChartPanel chartPanel) {
        this.chartPanel = chartPanel;
        this.table.changeChart(chartPanel.getChart());
    }

    protected void repaintChart() {
        this.chartPanel.repaint();
    }

    public static ArrayList<EditableProperty> getProperties(ChartStylePanel csp, Chart chart) {
        if (chart == null) {
            return new ArrayList<EditableProperty>();
        }
        ArrayList<EditableProperty> list = ChartStylePanel.getObjectProperties(csp, chart, "chart.", skipSet);
        ArrayList<EditableProperty> list2 = ChartStylePanel.getObjectProperties(csp, chart.getStyler(), "styler.", skipSet);
        list.addAll(list2);
        Map seriesMap = chart.getSeriesMap();
        int ind = 0;
        TreeSet<Integer> seriesIndSet = new TreeSet<Integer>();
        for (Map.Entry e : seriesMap.entrySet()) {
            MethodDescriptor[] series = (MethodDescriptor[])e.getValue();
            list2 = ChartStylePanel.getObjectProperties(csp, series, "series[" + (String)e.getKey() + "].", skipSet);
            list.addAll(list2);
            seriesIndSet.add(series.getYAxisGroup());
            seriesIndSet.add(ind);
            ++ind;
        }
        try {
            MethodDescriptor[] methodDescriptors = Introspector.getBeanInfo(chart.getClass()).getMethodDescriptors();
            HashMap<String, Method> chartMethodMap = new HashMap<String, Method>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                chartMethodMap.put(methodDescriptor.getName().toLowerCase(Locale.ENGLISH), methodDescriptor.getMethod());
            }
            methodDescriptors = Introspector.getBeanInfo(chart.getStyler().getClass()).getMethodDescriptors();
            HashMap<String, Method> stylerMethodMap = new HashMap<String, Method>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                stylerMethodMap.put(methodDescriptor.getName().toLowerCase(Locale.ENGLISH), methodDescriptor.getMethod());
            }
            for (Integer i : seriesIndSet) {
                EditableProperty styleEditor = new EditableProperty(csp, "chart.YAxisGroupTitle[" + i + "]", chart, (Method)chartMethodMap.get("getyaxisgrouptitle"), (Method)chartMethodMap.get("setyaxisgrouptitle"), i);
                list.add(styleEditor);
            }
        }
        catch (IntrospectionException e1) {
            e1.printStackTrace();
        }
        return list;
    }

    public static Method getMethod(PropertyDescriptor pd, boolean read, HashMap<String, Method> methodMap) {
        String[] prefixes;
        String[] stringArray;
        Method method;
        Method method2 = method = read ? pd.getReadMethod() : pd.getWriteMethod();
        if (method != null) {
            return method;
        }
        String lowerCaseName = pd.getName().toLowerCase(Locale.ENGLISH);
        if (read) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "get";
            stringArray = stringArray2;
            stringArray2[1] = "is";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "set";
        }
        for (String pre : prefixes = stringArray) {
            String name = pre + lowerCaseName;
            method = methodMap.get(name);
            if (method == null) continue;
            if (method.getParameterCount() != (read ? 0 : 1)) {
                method = null;
                continue;
            }
            return method;
        }
        return method;
    }

    public static ArrayList<EditableProperty> getObjectProperties(ChartStylePanel csp, Object obj, String prefix, Set<String> skipSet) {
        ArrayList<EditableProperty> list = new ArrayList<EditableProperty>();
        try {
            BeanInfo info = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            Arrays.sort(propertyDescriptors, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor a, PropertyDescriptor b) {
                    return a.getName().compareToIgnoreCase(b.getName());
                }
            });
            MethodDescriptor[] methodDescriptors = info.getMethodDescriptors();
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            for (MethodDescriptor methodDescriptor : methodDescriptors) {
                methodMap.put(methodDescriptor.getName().toLowerCase(Locale.ENGLISH), methodDescriptor.getMethod());
            }
            for (FeatureDescriptor featureDescriptor : propertyDescriptors) {
                try {
                    if (skipSet.contains(featureDescriptor.getName())) continue;
                    Method readMethod = ChartStylePanel.getMethod((PropertyDescriptor)featureDescriptor, true, methodMap);
                    if (readMethod == null) {
                        System.out.println("Skipping property (no read method): " + prefix + featureDescriptor.getName() + " " + ((PropertyDescriptor)featureDescriptor).getPropertyType());
                        continue;
                    }
                    Method writeMethod = ChartStylePanel.getMethod((PropertyDescriptor)featureDescriptor, false, methodMap);
                    if (writeMethod == null) {
                        System.out.println("Skipping property (no write method): " + prefix + featureDescriptor.getName() + " " + ((PropertyDescriptor)featureDescriptor).getPropertyType());
                        continue;
                    }
                    if (((PropertyDescriptor)featureDescriptor).getReadMethod().getReturnType().isArray()) {
                        Object arr = readMethod.invoke(obj, new Object[0]);
                        if (arr == null) continue;
                        int size = Array.getLength(arr);
                        Method rm = null;
                        Method wm = null;
                        for (int i = 0; i < size; ++i) {
                            EditableProperty styleEditor = new EditableProperty(csp, prefix + featureDescriptor.getName() + "[" + i + "]", arr, rm, wm, i);
                            list.add(styleEditor);
                        }
                        continue;
                    }
                    EditableProperty styleEditor = new EditableProperty(csp, prefix + featureDescriptor.getName(), obj, readMethod, writeMethod);
                    list.add(styleEditor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static class EditorTable
    extends JTable {
        EditorTableModel tableModel;

        public EditorTable(ChartStylePanel csp, Chart chart) {
            this.tableModel = new EditorTableModel(csp, chart);
            this.setModel(this.tableModel);
            this.setRowHeight(this.getRowHeight() * 2);
            this.setAutoResizeMode(3);
            TableColumnModel colmodel = this.getColumnModel();
            colmodel.getColumn(0).setPreferredWidth(200);
            colmodel.getColumn(1).setPreferredWidth(150);
            colmodel.getColumn(2).setPreferredWidth(400);
            this.setAutoCreateRowSorter(true);
        }

        public void changeChart(Chart chart) {
            this.tableModel.changeChart(chart);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            int modelRowIndex = this.convertRowIndexToModel(row);
            EditableProperty se = this.tableModel.getValueAt(modelRowIndex);
            TableCellEditor editor = se.getTableCellEditor();
            if (editor != null) {
                return editor;
            }
            Class valueClass = se.getValueClass();
            TableCellEditor defaultEditor = this.getDefaultEditor(valueClass);
            return defaultEditor;
        }
    }

    public static final class EditableProperty {
        String name;
        Method readMethod;
        Method writeMethod;
        Object obj;
        PropertyEditor editor;
        TableCellEditor cellEditor;
        ChartStylePanel csp;
        Object additionalParameter;
        static HashMap<Class, TableCellEditor> editorMap;
        static Class[] assignableClasses;

        public EditableProperty(ChartStylePanel csp, String name, Object obj, Method readMethod, Method writeMethod) {
            this(csp, name, obj, readMethod, writeMethod, null);
        }

        public EditableProperty(ChartStylePanel csp, String name, Object obj, Method readMethod, Method writeMethod, Object additionalParameter) {
            this.csp = csp;
            this.readMethod = readMethod;
            this.writeMethod = writeMethod;
            this.name = name;
            this.obj = obj;
            this.additionalParameter = additionalParameter;
            this.initEditor();
        }

        private void initEditor() {
            try {
                Object val = this.getValue();
                Class<?> cls = val == null ? this.getValueClass() : val.getClass();
                this.cellEditor = editorMap.get(cls);
                if (this.cellEditor != null) {
                    return;
                }
                if (cls.isEnum()) {
                    JComboBox comboBox = new JComboBox(cls.getEnumConstants());
                    this.cellEditor = new DefaultCellEditor(comboBox);
                    return;
                }
                for (Class class1 : assignableClasses) {
                    if (!class1.isAssignableFrom(cls)) continue;
                    this.cellEditor = editorMap.get(class1);
                    return;
                }
                this.editor = PropertyEditorManager.findEditor(cls);
                if (this.editor != null && this.editor.supportsCustomEditor()) {
                    this.cellEditor = new PropertyEditorAdapter(this.editor, this);
                    return;
                }
                System.out.println("Warning no editor found for property '" + this.name + "' with class " + cls);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.name;
        }

        public void setValue(Object aValue) {
            if (aValue != null && aValue instanceof LabelValue) {
                aValue = ((LabelValue)aValue).value;
            }
            try {
                if (this.additionalParameter == null) {
                    this.writeMethod.invoke(this.obj, aValue);
                } else if (this.writeMethod == null) {
                    Array.set(this.obj, (Integer)this.additionalParameter, aValue);
                } else {
                    this.writeMethod.invoke(this.obj, this.additionalParameter, aValue);
                }
                this.csp.repaintChart();
            }
            catch (Exception e) {
                Class<?>[] parameterTypes = this.writeMethod.getParameterTypes();
                if (aValue.getClass() != parameterTypes[0]) {
                    System.out.println(this.name + " " + this.writeMethod.getName() + " requires " + parameterTypes[0] + " but got " + aValue + " (" + (aValue == null ? null : aValue.getClass()) + ")");
                }
                e.printStackTrace();
            }
        }

        public Object getValue() {
            try {
                if (this.additionalParameter == null) {
                    return this.readMethod.invoke(this.obj, new Object[0]);
                }
                if (this.readMethod == null) {
                    return Array.get(this.obj, (Integer)this.additionalParameter);
                }
                return this.readMethod.invoke(this.obj, this.additionalParameter);
            }
            catch (Exception e) {
                System.out.println("Error reading " + this.name);
                e.printStackTrace();
                return null;
            }
        }

        public TableCellEditor getTableCellEditor() {
            return this.cellEditor;
        }

        public Class getValueClass() {
            if (this.readMethod == null) {
                return this.obj.getClass().getComponentType();
            }
            return this.readMethod.getReturnType();
        }

        static {
            Class[][] clsArr;
            assignableClasses = new Class[]{Theme.class, BasicStroke.class, Marker.class, TimeZone.class};
            editorMap = new HashMap();
            JComboBox<Boolean> comboBox = new JComboBox<Boolean>(new Boolean[]{Boolean.TRUE, Boolean.FALSE});
            Class[][] cellEditor = new DefaultCellEditor(comboBox);
            editorMap.put(Boolean.class, (TableCellEditor)cellEditor);
            editorMap.put(Boolean.TYPE, (TableCellEditor)cellEditor);
            for (Class[] classes : clsArr = new Class[][]{{Integer.TYPE, Integer.class}, {Byte.TYPE, Byte.class}, {Short.TYPE, Short.class}, {Long.TYPE, Long.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class, Number.class}, {String.class, String.class}}) {
                GenericEditorWithClass editor = new GenericEditorWithClass(classes[1]);
                for (Class class1 : classes) {
                    editorMap.put(class1, editor);
                }
            }
            comboBox = new JComboBox<Theme>(new Theme[]{new XChartTheme(), new GGPlot2Theme(), new MatlabTheme()});
            editorMap.put(Theme.class, new DefaultCellEditor(comboBox));
            Object[] values = new LabelValue[]{new LabelValue("NONE", SeriesLines.NONE), new LabelValue("SOLID", SeriesLines.SOLID), new LabelValue("DOT_DOT", SeriesLines.DOT_DOT), new LabelValue("DASH_DASH", SeriesLines.DASH_DASH), new LabelValue("DASH_DOT", SeriesLines.DASH_DOT)};
            JComboBox<Object> comboBox2 = new JComboBox<LabelValue>(values);
            editorMap.put(BasicStroke.class, new DefaultCellEditor(comboBox2));
            values = new LabelValue[]{new LabelValue("Base Grid Line", new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 5.0f}, 0.0f)), new LabelValue("GGPlot2 Grid Line", new BasicStroke(1.0f)), new LabelValue("Matlab Grid Line", new BasicStroke(0.5f, 0, 1, 10.0f, new float[]{1.0f, 3.0f}, 0.0f)), new LabelValue("Base Tick Marks", new BasicStroke(1.0f)), new LabelValue("GGPlot2 Tick Marks", new BasicStroke(1.5f)), new LabelValue("Matlab Tick Marks", new BasicStroke(0.5f))};
            comboBox2 = new JComboBox<LabelValue>(values);
            editorMap.put(Stroke.class, new DefaultCellEditor(comboBox2));
            Marker[] seriesMarkers = new BaseSeriesMarkers().getSeriesMarkers();
            comboBox2 = new JComboBox<Marker>(seriesMarkers);
            editorMap.put(Marker.class, new DefaultCellEditor(comboBox2));
            values = new Locale[]{Locale.ENGLISH, Locale.US, Locale.UK, Locale.FRANCE, Locale.FRANCE, Locale.ITALIAN, Locale.GERMAN, new Locale("tr", "tr")};
            comboBox2 = new JComboBox<Object>(values);
            editorMap.put(Locale.class, new DefaultCellEditor(comboBox2));
            String[] availableIDs = TimeZone.getAvailableIDs();
            TimeZone[] values2 = new TimeZone[availableIDs.length];
            for (int i = 0; i < values2.length; ++i) {
                values2[i] = TimeZone.getTimeZone(availableIDs[i]);
            }
            JComboBox<TimeZone> comboBox3 = new JComboBox<TimeZone>(values2);
            editorMap.put(TimeZone.class, new DefaultCellEditor(comboBox3));
        }
    }

    public static class EditorTableModel
    extends DefaultTableModel {
        ArrayList<EditableProperty> properties;
        Chart chart;
        int rowCount;
        ChartStylePanel csp;

        public EditorTableModel(ChartStylePanel csp, Chart chart) {
            this.csp = csp;
            this.addColumn("Name");
            this.addColumn("Type");
            this.addColumn("Value");
            this.changeChart(chart);
        }

        public void changeChart(Chart chart) {
            this.chart = chart;
            this.properties = ChartStylePanel.getProperties(this.csp, chart);
            this.rowCount = this.properties.size();
            this.fireTableStructureChanged();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Class.class;
                }
            }
            return Object.class;
        }

        public EditableProperty getValueAt(int row) {
            return this.properties.get(row);
        }

        @Override
        public Object getValueAt(int row, int column) {
            EditableProperty prop = this.properties.get(row);
            switch (column) {
                case 0: {
                    return prop.name;
                }
                case 1: {
                    return prop.getValueClass().getName();
                }
                case 2: {
                    return prop.getValue();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            EditableProperty prop = this.properties.get(rowIndex);
            prop.setValue(aValue);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }
    }

    static class GenericEditorWithClass
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;

        public GenericEditorWithClass(Class cls) {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
            try {
                this.constructor = cls.getConstructor(this.argTypes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            try {
                if ("".equals(s)) {
                    if (this.constructor.getDeclaringClass() == String.class) {
                        this.value = s;
                    }
                    return super.stopCellEditing();
                }
                this.value = this.constructor.newInstance(s);
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    public static class PropertyEditorAdapter
    extends AbstractCellEditor
    implements TableCellEditor {
        PropertyEditor editor;
        EditableProperty se;

        public PropertyEditorAdapter(PropertyEditor editor, EditableProperty se) {
            this.editor = editor;
            this.se = se;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editor.setValue(value);
            return this.editor.getCustomEditor();
        }
    }

    public static final class LabelValue {
        String label;
        Object value;

        public LabelValue(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        public String toString() {
            return this.label;
        }
    }
}

