/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.demo.ChartInfo;
import org.knowm.xchart.demo.DemoChartsUtil;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.demo.charts.area.AreaChart01;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.Styler;

public class XChartDemo
extends JPanel
implements TreeSelectionListener {
    private final JSplitPane splitPane;
    private final JTree tree;
    protected XChartPanel chartPanel;
    Timer timer = new Timer();

    public XChartDemo() {
        super(new GridLayout(1, 0));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("XChart Example Charts");
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.chartPanel = new XChartPanel((Chart)new AreaChart01().getChart());
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(treeView);
        this.splitPane.setBottomComponent((Component)this.chartPanel);
        Dimension minimumSize = new Dimension(130, 160);
        treeView.setMinimumSize(minimumSize);
        this.splitPane.setPreferredSize(new Dimension(700, 700));
        this.add(this.splitPane);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            ChartInfo chartInfo = (ChartInfo)nodeInfo;
            this.chartPanel = new XChartPanel(chartInfo.getExampleChart().getChart());
            this.splitPane.setBottomComponent((Component)this.chartPanel);
            this.timer.cancel();
            if (chartInfo.getExampleChart() instanceof RealtimeExampleChart) {
                final RealtimeExampleChart realtimeChart = (RealtimeExampleChart)((Object)chartInfo.getExampleChart());
                TimerTask chartUpdaterTask = new TimerTask(){

                    @Override
                    public void run() {
                        realtimeChart.updateData();
                        XChartDemo.this.chartPanel.revalidate();
                        XChartDemo.this.chartPanel.repaint();
                    }
                };
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
            }
        }
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode category = null;
        List<ExampleChart<Chart<Styler, Series>>> exampleList = DemoChartsUtil.getAllDemoCharts();
        String categoryName = "";
        for (ExampleChart<Chart<Styler, Series>> exampleChart : exampleList) {
            String name = exampleChart.getClass().getSimpleName();
            if (!categoryName.equals(name = name.substring(0, name.indexOf("Chart")))) {
                String label;
                String string = label = name.equals("") ? "Chart Themes" : name + " Charts";
                if (label.equals("Realtime Charts")) {
                    label = "Real-time Charts";
                }
                category = new DefaultMutableTreeNode(label);
                top.add(category);
                categoryName = name;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new ChartInfo(exampleChart.getExampleChartName(), exampleChart));
            category.add(defaultMutableTreeNode);
        }
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("XChart Demo");
        frame.setDefaultCloseOperation(3);
        frame.add(new XChartDemo());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XChartDemo.createAndShowGUI();
            }
        });
    }
}

