/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.bar;

import java.awt.Color;
import java.awt.Font;
import java.util.Random;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;

public class BarChart11
implements ExampleChart<CategoryChart> {
    public static void main(String[] args) {
        BarChart11 exampleChart = new BarChart11();
        CategoryChart chart = (CategoryChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    private static int[] getRandomValues(int startRange, int endRange, int count) {
        int[] values = new int[count];
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            values[i] = rand.nextInt(endRange - startRange) + startRange;
        }
        return values;
    }

    private static int[] getLinearValues(int startRange, int endRange, int count) {
        int[] values = new int[count];
        int step = (endRange - startRange) / count;
        for (int i = 0; i < count; ++i) {
            values[i] = step * i;
        }
        return values;
    }

    @Override
    public CategoryChart getChart() {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).xAxisTitle("Speed").yAxisTitle("Spin").build();
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setLegendVisible(false);
        ((CategoryStyler)chart.getStyler()).setStacked(true);
        ((CategoryStyler)chart.getStyler()).setLabelsVisible(true);
        ((CategoryStyler)chart.getStyler()).setLabelsFont(new Font("Monospaced", 1, 13));
        ((CategoryStyler)chart.getStyler()).setLabelsFontColor(Color.WHITE);
        ((CategoryStyler)chart.getStyler()).setLabelsPosition(0.5);
        ((CategoryStyler)chart.getStyler()).setLabelsFontColorAutomaticEnabled(false);
        ((CategoryStyler)chart.getStyler()).setLabelsRotation(45);
        CategorySeries series1 = chart.addSeries("series1", BarChart11.getLinearValues(0, 200, 6), BarChart11.getRandomValues(10, 50, 6));
        CategorySeries series2 = chart.addSeries("series2", BarChart11.getLinearValues(0, 200, 6), BarChart11.getRandomValues(10, 50, 6));
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Stacked Stepped Bars with Customized Data Labels";
    }
}

