/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.bar;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;

public class BarChart12
implements ExampleChart<CategoryChart> {
    public static void main(String[] args) {
        BarChart12 exampleChart = new BarChart12();
        CategoryChart chart = (CategoryChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    private static List<String> getMonths() {
        return Arrays.asList("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec");
    }

    private static List<Double> getRandomValues(int count) {
        ArrayList<Double> values = new ArrayList<Double>(count);
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            values.add(rand.nextDouble() * 1000.0);
        }
        return values;
    }

    @Override
    public CategoryChart getChart() {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).xAxisTitle("Month").yAxisTitle("Consumption").build();
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setLegendVisible(true);
        ((CategoryStyler)chart.getStyler()).setStacked(true);
        ((CategoryStyler)chart.getStyler()).setSeriesColors(new Color[]{Color.decode("#2133D0"), Color.decode("#FF3B47"), Color.decode("#FFBD00"), Color.DARK_GRAY});
        List<String> months = BarChart12.getMonths();
        List<Double> period1Values = BarChart12.getRandomValues(12);
        List<Double> period2Values = BarChart12.getRandomValues(12);
        List<Double> period3Values = BarChart12.getRandomValues(12);
        ArrayList<Double> averageValues = new ArrayList<Double>();
        for (int i = 0; i < 12; ++i) {
            averageValues.add((period1Values.get(i) + period2Values.get(i) + period3Values.get(i)) / 3.0);
        }
        CategorySeries staked1 = chart.addSeries("Period 1", months, period1Values);
        CategorySeries staked2 = chart.addSeries("Period 2", months, period2Values);
        CategorySeries staked3 = chart.addSeries("Period 3", months, period3Values);
        CategorySeries overlappedLine = chart.addSeries("Average", months, averageValues);
        overlappedLine.setOverlapped(true);
        overlappedLine.setChartCategorySeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Line);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Stacked Bars with Overlapped Line Chart";
    }
}

