/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class DateChart03
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        DateChart03 exampleChart = new DateChart03();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Minute Scale")).build();
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideS);
        ((XYStyler)chart.getStyler()).setYAxisGroupPosition(1, Styler.YAxisPosition.Right);
        ArrayList<Date> xData1 = new ArrayList<Date>();
        ArrayList<Double> yData1 = new ArrayList<Double>();
        ArrayList<Date> xData2 = new ArrayList<Date>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        Random random = new Random();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        for (int i = 1; i <= 14; ++i) {
            try {
                date = sdf.parse("2013-07-22-08:" + (5 * i + random.nextInt(2)) + ":" + random.nextInt(2) + "." + random.nextInt(1000));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            xData1.add(date);
            xData2.add(date);
            yData1.add(Math.random() * (double)i * 1.0E9);
            yData2.add(Math.random() * (double)i * 10.0);
        }
        chart.addSeries("series1", xData1, yData1).setYAxisGroup(1);
        chart.addSeries("series2", xData2, yData2);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Minute Scale with Two Separate Y Axis Groups";
    }
}

