/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.line;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.knowm.xchart.AnnotationImage;
import org.knowm.xchart.AnnotationLine;
import org.knowm.xchart.AnnotationText;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.internal.chartpart.Annotation;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.markers.None;

public class LineChart10
implements ExampleChart<XYChart> {
    public static void main(String[] args) {
        LineChart10 exampleChart = new LineChart10();
        XYChart chart = (XYChart)exampleChart.getChart();
        new SwingWrapper((Chart)chart).displayChart();
    }

    @Override
    public XYChart getChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title(this.getClass().getSimpleName())).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setAxisTitlesVisible(false);
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line);
        double start = 0.0;
        double end = 1.0;
        double increment = 0.01;
        ArrayList<Double> xData = new ArrayList<Double>();
        ArrayList<Double> yData = new ArrayList<Double>();
        for (double x = start; x <= end; x += increment) {
            double y = Math.exp(2.0 * x - 7.0 * x * x * x);
            xData.add(x);
            yData.add(y);
        }
        XYSeries series = chart.addSeries("series1", xData, yData);
        series.setMarker((Marker)new None());
        AnnotationLine maxY = new AnnotationLine(series.getYMax(), false, false);
        chart.addAnnotation((Annotation)maxY);
        AnnotationLine minY = new AnnotationLine(series.getYMin(), false, false);
        chart.addAnnotation((Annotation)minY);
        AnnotationLine xLine = new AnnotationLine(0.45, true, false);
        chart.addAnnotation((Annotation)xLine);
        AnnotationLine xLinePixel = new AnnotationLine(100.0, true, true);
        chart.addAnnotation((Annotation)xLinePixel);
        AnnotationText maxText = new AnnotationText("Max", 0.0, series.getYMax(), false);
        chart.addAnnotation((Annotation)maxText);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/XChart_64_64.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AnnotationImage annotationImage = new AnnotationImage(image, 0.0, 1.0, false);
        chart.addAnnotation((Annotation)annotationImage);
        return chart;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Annotations";
    }
}

