/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.awt.Component;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;

public class RealtimeChart03
implements ExampleChart<XYChart>,
RealtimeExampleChart {
    private XYChart xyChart;
    private List<Integer> xData = new CopyOnWriteArrayList<Integer>();
    private final List<Double> yData = new CopyOnWriteArrayList<Double>();
    private List<Double> errorBars = new CopyOnWriteArrayList<Double>();
    public static final String SERIES_NAME = "series1";

    public static void main(String[] args) {
        final RealtimeChart03 realtimeChart03 = new RealtimeChart03();
        final XChartPanel<XYChart> chartPanel = realtimeChart03.buildPanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("XChart");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                realtimeChart03.updateData();
                chartPanel.revalidate();
                chartPanel.repaint();
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    public XChartPanel<XYChart> buildPanel() {
        return new XChartPanel((Chart)this.getChart());
    }

    @Override
    public XYChart getChart() {
        int i;
        this.yData.add(0.0);
        for (i = 0; i < 50; ++i) {
            double lastPoint = this.yData.get(this.yData.size() - 1);
            this.yData.add(this.getRandomWalk(lastPoint));
        }
        this.xData = new CopyOnWriteArrayList<Integer>();
        for (i = 1; i < this.yData.size() + 1; ++i) {
            this.xData.add(i);
        }
        this.errorBars = new CopyOnWriteArrayList<Double>();
        for (i = 0; i < this.yData.size(); ++i) {
            this.errorBars.add(20.0 * Math.random());
        }
        this.xyChart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(500)).height(400)).xAxisTitle("X").yAxisTitle("Y").title("Real-time XY Chart with Error Bars")).build();
        this.xyChart.addSeries(SERIES_NAME, this.xData, this.yData, this.errorBars);
        return this.xyChart;
    }

    private Double getRandomWalk(double lastPoint) {
        return lastPoint + (Math.random() * 100.0 - 50.0);
    }

    @Override
    public void updateData() {
        double lastPoint = this.yData.get(this.yData.size() - 1);
        this.yData.add(this.getRandomWalk(lastPoint));
        this.yData.remove(0);
        this.errorBars.add(20.0 * Math.random());
        this.errorBars.remove(0);
        this.xyChart.updateXYSeries(SERIES_NAME, this.xData, this.yData, this.errorBars);
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time XY Chart with Error Bars";
    }
}

