/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.demo.charts.realtime;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.Histogram;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.demo.charts.ExampleChart;
import org.knowm.xchart.demo.charts.RealtimeExampleChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;

public class RealtimeChart05
implements ExampleChart<CategoryChart>,
RealtimeExampleChart {
    private CategoryChart categoryChart;
    private List<String> xData;
    private List<Double> yData;
    public static final String SERIES_NAME = "series1";

    public static void main(String[] args) {
        RealtimeChart05 realtimeChart01 = new RealtimeChart05();
        realtimeChart01.go();
    }

    private void go() {
        final SwingWrapper swingWrapper = new SwingWrapper((Chart)this.getChart());
        swingWrapper.displayChart();
        TimerTask chartUpdaterTask = new TimerTask(){

            @Override
            public void run() {
                RealtimeChart05.this.updateData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        swingWrapper.repaintChart();
                    }
                });
            }
        };
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(chartUpdaterTask, 0L, 500L);
    }

    @Override
    public CategoryChart getChart() {
        this.xData = new CopyOnWriteArrayList<String>(Arrays.asList("Blue", "Red", "Green", "Yellow", "Orange"));
        Histogram histogram = new Histogram(this.getGaussianData(1000), 5, -10.0, 10.0);
        this.yData = histogram.getyAxisData();
        this.categoryChart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(500)).height(400)).theme(Styler.ChartTheme.Matlab)).title("Real-time Category Chart")).build();
        this.categoryChart.addSeries(SERIES_NAME, this.xData, this.yData);
        return this.categoryChart;
    }

    @Override
    public void updateData() {
        Histogram histogram = new Histogram(this.getGaussianData(1000), 5, -10.0, 10.0);
        this.yData = histogram.getyAxisData();
        this.categoryChart.updateCategorySeries(SERIES_NAME, this.xData, this.yData, null);
    }

    private List<Double> getGaussianData(int count) {
        CopyOnWriteArrayList<Double> data = new CopyOnWriteArrayList<Double>();
        Random r = new Random();
        for (int i = 0; i < count; ++i) {
            data.add(r.nextGaussian() * 5.0);
        }
        return data;
    }

    @Override
    public String getExampleChartName() {
        return this.getClass().getSimpleName() + " - Real-time Category Chart";
    }
}

