/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.io.IOException;
import java.util.ArrayList;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.style.XYStyler;

public class TestForIssue240 {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 500;
    private static double[] xData = new double[]{1.0, 2.0, 3.0, 6.0, 7.0, 9.0, 12.0, 15.0, 17.0, 20.0};
    private static double[] yData = new double[]{-5.6, 15.0, 36.0, 27.0, 89.0, 74.0, 25.0, 16.0, 14.0, 46.0};

    public static void main(String[] args) throws IOException {
        ArrayList<XYChart> charts = new ArrayList<XYChart>();
        charts.add(TestForIssue240.getLineChart());
        charts.add(TestForIssue240.getSmoothedLineChart());
        charts.add(TestForIssue240.getSmoothedAreaChart());
        charts.add(TestForIssue240.getLineAndSmoothedAreaChart());
        new SwingWrapper(charts).displayChartMatrix();
    }

    private static XYChart getLineChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Line Chart")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        chart.addSeries("line", xData, yData);
        return chart;
    }

    private static XYChart getSmoothedLineChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Smoothed Line Chart")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        XYSeries series = chart.addSeries("smoothed line", xData, yData);
        series.setSmooth(true);
        return chart;
    }

    private static XYChart getSmoothedAreaChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Smoothed Area Chart")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        XYSeries series = chart.addSeries("smoothed area", xData, yData);
        series.setSmooth(true);
        series.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        return chart;
    }

    private static XYChart getLineAndSmoothedAreaChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(500)).title("Line And Smoothed Area Chart")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setLegendVisible(true);
        XYSeries series1 = chart.addSeries("smoothed area", xData, new double[]{10.0, 2.5, 5.6, 7.8, Double.NaN, -17.0, 58.0, 39.0, Double.NaN, 20.0});
        series1.setSmooth(true);
        series1.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        XYSeries series2 = chart.addSeries("line", xData, yData);
        series2.setSmooth(false);
        return chart;
    }
}

