/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.util.ArrayList;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;

public class TestForIssue325 {
    static final int WIDTH = 465;
    static final int HEIGHT = 320;

    public static void main(String[] args) {
        ArrayList<XYChart> charts = new ArrayList<XYChart>();
        int[] multiples = new int[]{1, 1000};
        int[] widths = new int[]{0, 15, 55};
        for (int m : multiples) {
            for (int width : widths) {
                XYChart chart = TestForIssue325.getChart(m, width);
                chart.setTitle("Multiple: " + m + " width: " + width);
                charts.add(chart);
            }
        }
        new SwingWrapper(charts, charts.size() / widths.length, widths.length).displayChartMatrix();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < charts.size(); ++i) {
            System.out.printf("%-30s on screen width: %5.2f%n", ((Chart)charts.get(i)).getTitle(), ((Chart)charts.get(i)).getYAxisLeftWidth());
        }
    }

    static XYChart getChart(int multiple, int yAxisLeftWidth) {
        int size = 30;
        ArrayList<Integer> xData = new ArrayList<Integer>(size);
        ArrayList<Double> yData = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            double radians = Math.PI / (double)(size / 2) * (double)i;
            xData.add(i * multiple);
            yData.add(Math.sin(radians) * (double)multiple);
        }
        XYChart chart = new XYChart(465, 320);
        chart.addSeries("Series 0", xData, yData);
        ((XYStyler)chart.getStyler()).setLegendVisible(false);
        ((XYStyler)chart.getStyler()).setYAxisLeftWidthHint(yAxisLeftWidth);
        return chart;
    }
}

