/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.issues;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.knowm.xchart.BubbleChart;
import org.knowm.xchart.BubbleChartBuilder;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.Histogram;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.BubbleStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class TestForIssue54_1 {
    static final int WIDTH = 465;
    static final int HEIGHT = 320;

    public static void main(String[] args) {
        ArrayList<Chart> charts = new ArrayList<Chart>();
        Chart chart = TestForIssue54_1.getLineChart();
        chart.setTitle("Default axis");
        charts.add(chart);
        chart = TestForIssue54_1.getLineChart();
        chart.setTitle("sin(x) on second axis with title");
        Series series = (Series)chart.getSeriesMap().get("y=sin(x)");
        series.setYAxisGroup(1);
        chart.setYAxisGroupTitle(1, "sin(x)");
        charts.add(chart);
        chart = TestForIssue54_1.getAreaChart();
        chart.setTitle("Default axis");
        charts.add(chart);
        chart = TestForIssue54_1.getAreaChart();
        chart.setTitle("all different axis, b & c axis on right");
        series = (Series)chart.getSeriesMap().get("b");
        series.setYAxisGroup(1);
        series = (Series)chart.getSeriesMap().get("c");
        series.setYAxisGroup(2);
        chart.getStyler().setYAxisGroupPosition(1, Styler.YAxisPosition.Right);
        chart.getStyler().setYAxisGroupPosition(2, Styler.YAxisPosition.Right);
        charts.add(chart);
        chart = TestForIssue54_1.getCaregoryChart();
        chart.setTitle("Default axis");
        charts.add(chart);
        chart = TestForIssue54_1.getCaregoryChart();
        chart.setTitle("b on second axis, b on right");
        series = (Series)chart.getSeriesMap().get("b");
        series.setYAxisGroup(1);
        chart.getStyler().setYAxisGroupPosition(1, Styler.YAxisPosition.Right);
        charts.add(chart);
        chart = TestForIssue54_1.getCategoryLineChart();
        chart.setTitle("Default axis");
        charts.add(chart);
        chart = TestForIssue54_1.getCategoryLineChart();
        chart.setTitle("b&d on second axis");
        series = (Series)chart.getSeriesMap().get("b");
        series.setYAxisGroup(1);
        series = (Series)chart.getSeriesMap().get("d");
        series.setYAxisGroup(1);
        chart.getStyler().setYAxisGroupPosition(1, Styler.YAxisPosition.Right);
        charts.add(chart);
        chart = TestForIssue54_1.getBubleChart();
        chart.setTitle("Default axis");
        charts.add(chart);
        chart = TestForIssue54_1.getBubleChart();
        chart.setTitle("b on second axis");
        series = (Series)chart.getSeriesMap().get("b");
        series.setYAxisGroup(1);
        charts.add(chart);
        chart = TestForIssue54_1.getLineChart();
        chart.setTitle("Default axis on right");
        chart.getStyler().setYAxisGroupPosition(0, Styler.YAxisPosition.Right);
        charts.add(chart);
        new SwingWrapper(charts).displayChartMatrix();
    }

    static Chart getLineChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(465)).height(320)).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setToolTipsEnabled(true);
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNW);
        int size = 30;
        ArrayList<Integer> xData = new ArrayList<Integer>();
        ArrayList<Double> yData = new ArrayList<Double>();
        ArrayList<Integer> xData2 = new ArrayList<Integer>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        for (int i = 0; i <= size; ++i) {
            double radians = Math.PI / (double)(size / 2) * (double)i;
            int x = i - size / 2;
            xData.add(x);
            yData.add(-1.0 * Math.sin(radians));
            xData2.add(x);
            yData2.add(-10.0 * Math.cos(radians));
        }
        chart.addSeries("y=sin(x)", xData, yData);
        chart.addSeries("y=cos(x)", xData2, yData2);
        return chart;
    }

    static Chart getAreaChart() {
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(465)).height(320)).title("Area chart")).xAxisTitle("X").yAxisTitle("Y").build();
        ((XYStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNW);
        ((XYStyler)chart.getStyler()).setAxisTitlesVisible(true);
        chart.setYAxisGroupTitle(0, "a");
        chart.setYAxisGroupTitle(1, "b");
        chart.setYAxisGroupTitle(2, "c");
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        ((XYStyler)chart.getStyler()).setToolTipsEnabled(true);
        chart.addSeries("a", new double[]{0.0, 3.0, 6.0, 9.0, 12.0}, new double[]{-1.0, 5.0, 9.0, 6.0, 5.0});
        chart.addSeries("b", new double[]{1.0, 4.0, 7.0, 10.0, 13.0}, new double[]{-10.0, 50.0, 90.0, 60.0, 50.0});
        chart.addSeries("c", new double[]{2.0, 5.0, 8.0, 11.0, 14.0}, new double[]{-100.0, 500.0, 900.0, 600.0, 500.0});
        return chart;
    }

    static CategoryChart getCaregoryChart() {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(465)).height(320)).title("Score Histogram")).xAxisTitle("Mean").yAxisTitle("Count").build();
        ((CategoryStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.InsideNW);
        ((CategoryStyler)chart.getStyler()).setAvailableSpaceFill(0.96);
        ((CategoryStyler)chart.getStyler()).setPlotGridVerticalLinesVisible(false);
        ((CategoryStyler)chart.getStyler()).setToolTipsEnabled(true);
        ((CategoryStyler)chart.getStyler()).setToolTipType(Styler.ToolTipType.yLabels);
        List<Integer> data = TestForIssue54_1.getGaussianData(1000);
        ArrayList<Integer> data2 = new ArrayList<Integer>(10000);
        for (Integer val : data) {
            data2.add(val);
            data2.add(val);
        }
        Histogram histogram1 = new Histogram(data, 10, -30.0, 30.0);
        chart.addSeries("a", histogram1.getxAxisData(), histogram1.getyAxisData());
        Histogram histogram2 = new Histogram(data2, 10, -30.0, 30.0);
        chart.addSeries("b", histogram2.getxAxisData(), histogram2.getyAxisData());
        return chart;
    }

    static List<Integer> getGaussianData(int count) {
        ArrayList<Integer> data = new ArrayList<Integer>(count);
        Random r = new Random();
        for (int i = 0; i < count; ++i) {
            data.add((int)(r.nextGaussian() * 10.0));
        }
        return data;
    }

    static CategoryChart getCategoryLineChart() {
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(465)).height(320)).theme(Styler.ChartTheme.GGPlot2)).title("ThreadPool Benchmark")).xAxisTitle("Threads").yAxisTitle("Executions").build();
        ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Line);
        ((CategoryStyler)chart.getStyler()).setXAxisLabelRotation(270);
        ((CategoryStyler)chart.getStyler()).setLegendPosition(Styler.LegendPosition.OutsideE);
        ((CategoryStyler)chart.getStyler()).setAvailableSpaceFill(0.0);
        ((CategoryStyler)chart.getStyler()).setOverlapped(true);
        ((CategoryStyler)chart.getStyler()).setToolTipsEnabled(true);
        List<String> xAxisKeys = Arrays.asList("release-0.5", "release-0.6", "release-0.7", "release-0.8", "release-0.9");
        String[] seriesNames = new String[]{"a", "b", "c", "d"};
        Integer[][] dataPerSeries = new Integer[][]{{5, 20, 15, 25, 35}, {10, 40, 30, 50, 70}, {20, 80, 60, 100, 140}, {45, 121, 151, 231, 381}};
        for (int i = 0; i < seriesNames.length; ++i) {
            chart.addSeries(seriesNames[i], xAxisKeys, Arrays.asList(dataPerSeries[i]));
        }
        return chart;
    }

    static BubbleChart getBubleChart() {
        BubbleChart chart = ((BubbleChartBuilder)((BubbleChartBuilder)((BubbleChartBuilder)new BubbleChartBuilder().width(465)).height(320)).title("BubbleChart01")).xAxisTitle("X").yAxisTitle("Y").build();
        ((BubbleStyler)chart.getStyler()).setToolTipsEnabled(true);
        double[] xData = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] yData = new double[]{10.0, 4.0, 7.0, 7.7};
        double[] bubbleData = new double[]{17.0, 40.0, 50.0, 51.0};
        double[] yData2 = new double[]{10.0, 20.0, 30.0, 40.0};
        double[] bubbleData2 = new double[]{37.0, 35.0, 80.0, 27.0};
        chart.addSeries("a", xData, yData, bubbleData);
        chart.addSeries("b", xData, yData2, bubbleData2);
        return chart;
    }
}

