/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.standalone.readme;

import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingWorker;
import org.knowm.xchart.QuickChart;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;

public class SwingWorkerRealTime {
    MySwingWorker mySwingWorker;
    SwingWrapper<XYChart> sw;
    XYChart chart;

    public static void main(String[] args) throws Exception {
        SwingWorkerRealTime swingWorkerRealTime = new SwingWorkerRealTime();
        swingWorkerRealTime.go();
    }

    private void go() {
        this.chart = QuickChart.getChart((String)"SwingWorker XChart Real-time Demo", (String)"Time", (String)"Value", (String)"randomWalk", (double[])new double[]{0.0}, (double[])new double[]{0.0});
        ((XYStyler)this.chart.getStyler()).setLegendVisible(false);
        ((XYStyler)this.chart.getStyler()).setXAxisTicksVisible(false);
        this.sw = new SwingWrapper((Chart)this.chart);
        this.sw.displayChart();
        this.mySwingWorker = new MySwingWorker();
        this.mySwingWorker.execute();
    }

    private class MySwingWorker
    extends SwingWorker<Boolean, double[]> {
        final LinkedList<Double> fifo = new LinkedList();

        public MySwingWorker() {
            this.fifo.add(0.0);
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            while (!this.isCancelled()) {
                this.fifo.add(this.fifo.get(this.fifo.size() - 1) + Math.random() - 0.5);
                if (this.fifo.size() > 500) {
                    this.fifo.removeFirst();
                }
                double[] array = new double[this.fifo.size()];
                for (int i = 0; i < this.fifo.size(); ++i) {
                    array[i] = this.fifo.get(i);
                }
                this.publish((V[])new double[][]{array});
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    System.out.println("MySwingWorker shut down.");
                }
            }
            return true;
        }

        @Override
        protected void process(List<double[]> chunks) {
            System.out.println("number of chunks: " + chunks.size());
            double[] mostRecentDataSet = chunks.get(chunks.size() - 1);
            SwingWorkerRealTime.this.chart.updateXYSeries("randomWalk", null, mostRecentDataSet, null);
            SwingWorkerRealTime.this.sw.repaintChart();
            long start = System.currentTimeMillis();
            long duration = System.currentTimeMillis() - start;
            try {
                Thread.sleep(40L - duration);
            }
            catch (InterruptedException e) {
                System.out.println("InterruptedException occurred.");
            }
        }
    }
}

