/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TimeDist;

public class Arrival
implements Cloneable {
    protected SeismicPhase phase;
    protected double time;
    protected double dist;
    protected double rayParam;
    protected int rayParamIndex;
    protected String name;
    protected String puristName;
    protected double sourceDepth;
    protected TimeDist[] pierce;
    protected TimeDist[] path;
    protected static final double TWOPI = Math.PI * 2;
    protected static final double DtoR = Math.PI / 180;
    protected static final double RtoD = 57.29577951308232;

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, String name, String puristName, double sourceDepth) {
        this.phase = phase;
        this.time = time;
        this.dist = dist;
        this.rayParam = rayParam;
        this.rayParamIndex = rayParamIndex;
        this.name = name;
        this.puristName = puristName;
        this.sourceDepth = sourceDepth;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public double getTime() {
        return this.time;
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double moduloDist = this.getDist() % (Math.PI * 2);
        if (moduloDist > Math.PI) {
            moduloDist = Math.PI * 2 - moduloDist;
        }
        return moduloDist;
    }

    public double getModuloDistDeg() {
        double moduloDist = 57.29577951308232 * this.getDist() % 360.0;
        if (moduloDist > 180.0) {
            moduloDist = 360.0 - moduloDist;
        }
        return moduloDist;
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public TimeDist[] getPierce() {
        return this.pierce;
    }

    public TimeDist[] getPath() {
        return this.path;
    }

    public Object clone() {
        try {
            int i;
            Arrival newObject = (Arrival)super.clone();
            if (this.pierce != null) {
                newObject.pierce = new TimeDist[this.pierce.length];
                for (i = 0; i < this.pierce.length; ++i) {
                    newObject.pierce[i] = this.pierce[i] != null ? (TimeDist)this.pierce[i].clone() : null;
                }
            }
            if (this.path != null) {
                newObject.path = new TimeDist[this.path.length];
                for (i = 0; i < this.path.length; ++i) {
                    newObject.path[i] = (TimeDist)this.path[i].clone();
                }
            }
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        String desc = "time=" + this.time + " dist=" + this.dist + " rayParam=" + this.rayParam + " rayParamIndex=" + this.rayParamIndex + " name=" + this.name;
        if (this.pierce != null) {
            System.out.println("\nPierce:");
            for (int i = 0; i < this.pierce.length; ++i) {
                System.out.println(this.pierce[i]);
            }
        }
        return desc;
    }

    public int getNumPiercePoints() {
        if (this.pierce != null) {
            return this.pierce.length;
        }
        return 0;
    }

    public int getNumPathPoints() {
        if (this.path != null) {
            return this.path.length;
        }
        return 0;
    }

    public TimeDist getPiercePoint(int i) {
        return this.pierce[i];
    }

    public TimeDist getFirstPiercePoint(double depth) {
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].depth != depth) continue;
            return this.pierce[i];
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
    }

    public TimeDist getLastPiercePoint(double depth) {
        TimeDist piercepoint = null;
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].depth != depth) continue;
            piercepoint = this.pierce[i];
        }
        if (piercepoint == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
        }
        return piercepoint;
    }

    public TimeDist getPathPoint(int i) {
        return this.path[i];
    }
}

