/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TimeDist;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Vector;

public class PolarPlot
extends Canvas {
    Container pappy;
    Dimension minSize;
    int width;
    protected Vector segments = new Vector();
    double[] circleRadius;
    double outsideRadius = 6371.0;
    int centerX;
    int centerY;
    public static final short FULL = 0;
    public static final short HALF = 1;
    public static final short QUARTER = 2;
    short displayMode;

    public PolarPlot(Container parent) {
        this.pappy = parent;
        this.width = 250;
        this.minSize = new Dimension(this.width, this.width);
        this.setDisplayMode((short)0);
    }

    public PolarPlot(Container parent, int width) {
        this.pappy = parent;
        this.width = width;
        this.minSize = new Dimension(width, width);
        this.setDisplayMode((short)0);
    }

    public void setCircles(double[] circles) {
        this.circleRadius = new double[circles.length];
        for (int i = 0; i < circles.length; ++i) {
            this.circleRadius[i] = circles[i];
        }
    }

    public void setOutsideRadius(double r) {
        this.outsideRadius = r;
    }

    public void appendSegment(TimeDist[] td) {
        this.segments.addElement(td);
    }

    public void clearSegments() {
        this.segments.removeAllElements();
    }

    public void setDisplayMode(short mode) {
        this.displayMode = mode;
        switch (this.displayMode) {
            case 0: {
                this.centerX = this.width / 2;
                this.centerY = this.width / 2;
                break;
            }
            case 1: {
                this.centerX = this.width / 2;
                this.centerY = this.width;
                break;
            }
            case 2: {
                this.centerX = 0;
                this.centerY = this.width;
            }
        }
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public synchronized Dimension minimumSize() {
        return this.minSize;
    }

    public Insets insets() {
        return new Insets(5, 5, 5, 5);
    }

    public void paint(Graphics g) {
        FontMetrics fontMetrics = g.getFontMetrics();
        g.drawRect(0, 0, this.width - 1, this.width - 1);
        this.plotCircles(g);
        this.plotData(g);
    }

    protected void plotCircles(Graphics g) {
        if (this.circleRadius != null) {
            switch (this.displayMode) {
                case 0: {
                    for (int i = 0; i < this.circleRadius.length; ++i) {
                        int radius = (int)Math.rint(this.circleRadius[i] / this.outsideRadius * (double)this.width / 2.0);
                        g.drawOval(this.width / 2 - radius, this.width / 2 - radius, 2 * radius, 2 * radius);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.circleRadius.length; ++i) {
                        int radius = (int)Math.rint(this.circleRadius[i] / this.outsideRadius * (double)this.width / 2.0);
                        g.drawArc(this.width / 2 - radius, this.width - radius, 2 * radius, 2 * radius, 0, 180);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.circleRadius.length; ++i) {
                        int radius = (int)Math.rint(this.circleRadius[i] / this.outsideRadius * (double)this.width);
                        g.drawArc(-1 * radius, this.width - radius, 2 * radius, 2 * radius, 0, 90);
                    }
                    break;
                }
            }
        }
    }

    protected void plotData(Graphics g) {
        int numSegments = this.segments.size();
        double scale = (double)this.centerY / this.outsideRadius;
        for (int segNum = 0; segNum < numSegments; ++segNum) {
            g.setColor(this.colorForSegment(segNum));
            TimeDist[] data = (TimeDist[])this.segments.elementAt(segNum);
            for (int i = 0; i < data.length - 1; ++i) {
                g.drawLine(this.centerX - (int)Math.rint((this.outsideRadius - data[i].depth) * Math.cos(data[i].dist + 1.5707963267948966) * scale), this.centerY - (int)Math.rint((this.outsideRadius - data[i].depth) * Math.sin(data[i].dist + 1.5707963267948966) * scale), this.centerX - (int)Math.rint((this.outsideRadius - data[i + 1].depth) * Math.cos(data[i + 1].dist + 1.5707963267948966) * scale), this.centerY - (int)Math.rint((this.outsideRadius - data[i + 1].depth) * Math.sin(data[i + 1].dist + 1.5707963267948966) * scale));
            }
        }
        g.setColor(Color.black);
    }

    public Color colorForSegment(int segNum) {
        if (this.segments.size() == 1) {
            return Color.black;
        }
        int colorInc = (int)Math.floor(255 / (this.segments.size() - 1));
        return new Color(segNum * colorInc, 255 - segNum * colorInc, segNum % 3 * 127);
    }
}

