/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Assert;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import java.io.Serializable;

public class SlownessLayer
implements Serializable,
Cloneable {
    private double topP;
    private double botP;
    private double topDepth;
    private double botDepth;

    public SlownessLayer(double topP, double topDepth, double botP, double botDepth) {
        Assert.isFalse(topDepth > botDepth, "topDepth > botDepth: " + topDepth + " > " + botDepth);
        Assert.isFalse(topDepth < 0.0 || Double.isNaN(topDepth) || Double.isInfinite(topDepth), "topDepth is not a number or is negative: " + topDepth);
        Assert.isFalse(botDepth < 0.0 || Double.isNaN(botDepth) || Double.isInfinite(botDepth), "botDepth is not a number or is negative: " + botDepth);
        this.setTopP(topP);
        this.setTopDepth(topDepth);
        this.setBotP(botP);
        this.setBotDepth(botDepth);
    }

    public SlownessLayer(VelocityLayer vLayer, boolean spherical, double radiusOfEarth, boolean isPWave) {
        Assert.isFalse(vLayer.getTopDepth() > vLayer.getBotDepth(), "vLayer.topDepth > vLayer.botDepth :" + vLayer.getTopDepth() + " " + vLayer.getBotDepth());
        this.setTopDepth(vLayer.getTopDepth());
        this.setBotDepth(vLayer.getBotDepth());
        char waveType = isPWave ? (char)'P' : 'S';
        try {
            if (spherical) {
                this.setTopP((radiusOfEarth - this.getTopDepth()) / vLayer.evaluateAtTop(waveType));
                this.setBotP((radiusOfEarth - this.getBotDepth()) / vLayer.evaluateAtBottom(waveType));
            } else {
                this.setTopP(1.0 / vLayer.evaluateAtTop(waveType));
                this.setBotP(1.0 / vLayer.evaluateAtBottom(waveType));
            }
            Assert.isFalse(Double.isNaN(this.getTopP()) || Double.isNaN(this.getBotP()), "Slowness sample is NaN: topP=" + this.getTopP() + " botP=" + this.getBotP());
        }
        catch (NoSuchMatPropException e) {
            e.printStackTrace();
        }
    }

    public SlownessLayer(VelocityLayer vLayer, boolean isPWave, double radiusOfEarth) {
        this(vLayer, true, radiusOfEarth, isPWave);
    }

    public SlownessLayer(VelocityLayer vLayer, boolean isPWave) {
        this(vLayer, false, 0.0, isPWave);
    }

    public void setTopP(double topP) {
        this.topP = topP;
    }

    public double getTopP() {
        return this.topP;
    }

    public void setBotP(double botP) {
        this.botP = botP;
    }

    public double getBotP() {
        return this.botP;
    }

    public void setTopDepth(double topDepth) {
        this.topDepth = topDepth;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public void setBotDepth(double botDepth) {
        this.botDepth = botDepth;
    }

    public double getBotDepth() {
        return this.botDepth;
    }

    public boolean isZeroThickness() {
        return this.getTopDepth() == this.getBotDepth();
    }

    public double evaluateAt_bullen(double depth, double radiusOfEarth) throws SlownessModelException {
        Assert.isFalse(this.getBotDepth() > radiusOfEarth, "SlownessLayer.evaluateAt_bullen: radiusOfEarth=" + radiusOfEarth + " is smaller than the maximum depth of this layer." + " topDepth=" + this.getTopDepth() + " botDepth=" + this.getBotDepth());
        Assert.isFalse((this.getTopDepth() - depth) * (depth - this.getBotDepth()) < 0.0, "SlownessLayer.evaluateAt_bullen: depth=" + depth + " is not contained within this layer." + " topDepth=" + this.getTopDepth() + " botDepth=" + this.getBotDepth());
        if (depth == this.getTopDepth()) {
            return this.getTopP();
        }
        if (depth == this.getBotDepth()) {
            return this.getBotP();
        }
        double B = Math.log(this.getTopP() / this.getBotP()) / Math.log((radiusOfEarth - this.getTopDepth()) / (radiusOfEarth - this.getBotDepth()));
        double A = this.getTopP() / Math.pow(radiusOfEarth - this.getTopDepth(), B);
        double answer = A * Math.pow(radiusOfEarth - depth, B);
        if (answer < 0.0 || Double.isNaN(answer) || Double.isInfinite(answer)) {
            double linear;
            if (this.getBotDepth() - this.getTopDepth() < 2.0 && !((linear = (this.getBotP() - this.getTopP()) / (this.getBotDepth() - this.getTopDepth()) * (depth - this.getTopDepth()) + this.getTopP()) < 0.0) && !Double.isNaN(linear) && !Double.isInfinite(linear)) {
                return linear;
            }
            throw new SlownessModelException("calculated slowness is not a number or is negative: " + answer + "\n" + this.toString() + "\n A=" + A + "   B=" + B);
        }
        return answer;
    }

    public TimeDist bullenRadialSlowness(double p, double radiusOfEarth) throws SlownessModelException {
        TimeDist timedist = new TimeDist(p);
        if (this.getTopDepth() == this.getBotDepth()) {
            timedist.dist = 0.0;
            timedist.time = 0.0;
            return timedist;
        }
        if (this.getBotDepth() - this.getTopDepth() < 1.0E-9) {
            return timedist;
        }
        double B = Math.log(this.getTopP() / this.getBotP()) / Math.log((radiusOfEarth - this.getTopDepth()) / (radiusOfEarth - this.getBotDepth()));
        double sqrtTopTopMpp = Math.sqrt(this.getTopP() * this.getTopP() - p * p);
        double sqrtBotBotMpp = Math.sqrt(this.getBotP() * this.getBotP() - p * p);
        timedist.dist = 1.0 / B * (Math.atan2(p, sqrtBotBotMpp) - Math.atan2(p, sqrtTopTopMpp));
        timedist.time = 1.0 / B * (sqrtTopTopMpp - sqrtBotBotMpp);
        if (timedist.dist < 0.0 || timedist.time < 0.0 || Double.isNaN(timedist.time) || Double.isNaN(timedist.dist)) {
            throw new SlownessModelException("timedist <0.0 or NaN: \n RayParam= " + p + "\n topDepth = " + this.getTopDepth() + "\n botDepth = " + this.getBotDepth() + "\n dist=" + timedist.dist + "\n time=" + timedist.time + "\n topP = " + this.getTopP() + "\n botP = " + this.getBotP() + "\n B = " + B + " " + this.toString());
        }
        return timedist;
    }

    public double bullenDepthFor(double rayParam, double radiusOfEarth) throws SlownessModelException {
        if ((this.getTopP() - rayParam) * (rayParam - this.getBotP()) >= 0.0) {
            if (this.getTopDepth() == this.getBotDepth()) {
                return this.getBotDepth();
            }
            if (this.getBotP() != 0.0 && this.getBotDepth() != radiusOfEarth) {
                double A;
                double B = Math.log(this.getTopP() / this.getBotP()) / Math.log((radiusOfEarth - this.getTopDepth()) / (radiusOfEarth - this.getBotDepth()));
                double tempDepth = radiusOfEarth - Math.exp(1.0 / B * Math.log(rayParam / (A = this.getTopP() / Math.pow(radiusOfEarth - this.getTopDepth(), B))));
                if (tempDepth < 0.0 || Double.isNaN(tempDepth) || Double.isInfinite(tempDepth) || tempDepth < this.getTopDepth() || tempDepth > this.getBotDepth()) {
                    double linear;
                    if (this.getBotDepth() - this.getTopDepth() < 5.0 && !((linear = (this.getBotDepth() - this.getTopDepth()) / (this.getBotP() - this.getTopP()) * (rayParam - this.getTopP()) + this.getTopDepth()) < 0.0) && !Double.isNaN(linear) && !Double.isInfinite(linear)) {
                        return linear;
                    }
                    throw new SlownessModelException("claculated depth is not a number or is negative: " + tempDepth + "\n" + this + "\n" + A + "  " + B + "\n" + rayParam);
                }
                if (tempDepth < this.getTopDepth() && this.getTopDepth() - tempDepth < 1.0E-10) {
                    return this.getTopDepth();
                }
                if (tempDepth > this.getBotDepth() && tempDepth - this.getBotDepth() < 1.0E-10) {
                    return this.getBotDepth();
                }
                return tempDepth;
            }
            if (this.getTopP() != this.getBotP()) {
                return this.getBotDepth() + (rayParam - this.getBotP()) * (this.getTopDepth() - this.getBotDepth()) / (this.getTopP() - this.getBotP());
            }
            return this.getBotDepth();
        }
        throw new SlownessModelException("Ray parameter = " + rayParam + " is not contained within this slowness layer. topP=" + this.getTopP() + " botP=" + this.getBotP());
    }

    public Object clone() {
        try {
            SlownessLayer newObject = (SlownessLayer)super.clone();
            return newObject;
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Caught CloneNotSupportedException: " + e.getMessage());
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        String desc = "top p " + this.getTopP() + ", topDepth " + this.getTopDepth() + ", bot p " + this.getBotP() + ", botDepth " + this.getBotDepth();
        return desc;
    }

    public boolean validate() throws SlownessModelException {
        if (Double.isNaN(this.getTopP()) || Double.isNaN(this.getTopDepth()) || Double.isNaN(this.getBotP()) || Double.isNaN(this.getBotDepth())) {
            throw new SlownessModelException("Slowness layer has NaN values.\n " + this);
        }
        if (this.getTopP() < 0.0 || this.getBotP() < 0.0) {
            throw new SlownessModelException("Slowness layer has negative slownesses. \n " + this);
        }
        if (this.getTopDepth() > this.getBotDepth()) {
            throw new SlownessModelException("Slowness layer has negative thickness. \n" + this);
        }
        return true;
    }
}

