/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class SphericalSModel
extends SlownessModel
implements Serializable,
Cloneable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String modelFilename;
        System.out.println("Starting main");
        VelocityModel vMod = new VelocityModel();
        SphericalSModel sMod = new SphericalSModel();
        if (args.length == 1) {
            modelFilename = args[0];
        } else {
            vMod.setFileType("tvel");
            modelFilename = File.separator + "MacintoshHD" + File.separator + "Philip" + File.separator + "TauP" + File.separator + "VModels" + File.separator + "iasp91.tvel";
        }
        boolean DEBUG = true;
        try {
            DEBUG = true;
            vMod.readVelocityFile(modelFilename);
            System.out.println("Done reading.");
            if (DEBUG) {
                System.out.println(vMod);
            }
            DEBUG = true;
            sMod.DEBUG = true;
            sMod.createSample(vMod);
            if (sMod.DEBUG) {
                System.out.println(sMod);
            }
            sMod.validate();
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage() + "\n" + e.getClass().getName());
            e.printStackTrace();
        }
        catch (VelocityModelException e) {
            System.out.println("Tried to read!\n Caught VelocityModelException " + e.getMessage());
            e.printStackTrace();
        }
        catch (SlownessModelException e) {
            System.out.println(vMod);
            System.out.println(sMod);
            System.out.println("Tried to create slowness!\n Caught SlownessModelException " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            System.out.println("Done!\n");
        }
    }

    public double toSlowness(double velocity, double depth) throws SlownessModelException {
        if (velocity == 0.0) {
            throw new SlownessModelException("Divide by zero in toSlowness()\ndepth = " + depth + "\nThis likely has to do with using S velocities in the outer core");
        }
        return (this.radiusOfEarth - depth) / velocity;
    }

    public double toVelocity(double slowness, double depth) throws SlownessModelException {
        if (slowness == 0.0) {
            throw new SlownessModelException("Divide by zero in toVelocity()\ndepth = " + depth + "\nPossibly this is due to depth at center of the earth?");
        }
        return (this.radiusOfEarth - depth) / slowness;
    }

    public SlownessLayer toSlownessLayer(VelocityLayer vLayer, boolean isPWave) throws SlownessModelException {
        return new SlownessLayer(vLayer, true, this.radiusOfEarth, isPWave);
    }

    public double interpolate(double p, double topVelocity, double topDepth, double slope) throws SlownessModelException {
        double denominator = p * slope + 1.0;
        if (denominator == 0.0) {
            double depth = Double.MAX_VALUE;
            throw new SlownessModelException("Neg velocity gradient just balances the earth flattening! What should I do?!?!?!? topDepth= " + topDepth);
        }
        double depth = (this.radiusOfEarth + p * (topDepth * slope - topVelocity)) / denominator;
        return depth;
    }

    public TimeDist layerTimeDist(double sphericalRayParam, int layerNum, boolean isPWave) throws SlownessModelException {
        TimeDist timedist = new TimeDist(sphericalRayParam);
        SlownessLayer sphericalLayer = this.getSlownessLayer(layerNum, isPWave);
        double topRadius = this.radiusOfEarth - sphericalLayer.getTopDepth();
        double botRadius = this.radiusOfEarth - sphericalLayer.getBotDepth();
        if (sphericalRayParam > Math.max(sphericalLayer.getTopP(), sphericalLayer.getBotP())) {
            throw new SlownessModelException("Ray cannot propagate within this layer. layerNum = " + layerNum + " sphericalRayParam=" + sphericalRayParam + "\n" + sphericalLayer);
        }
        if (sphericalRayParam < 0.0) {
            throw new SlownessModelException("Ray Parameter is negative!!! " + sphericalRayParam);
        }
        if (sphericalRayParam > Math.min(sphericalLayer.getTopP(), sphericalLayer.getBotP())) {
            if (this.DEBUG) {
                System.out.println("Ray Turns in layer, velocities: " + topRadius / sphericalRayParam + " " + topRadius / sphericalLayer.getTopP() + " " + botRadius / sphericalLayer.getBotP());
                System.out.println("depths        top " + sphericalLayer.getTopDepth() + "  bot " + sphericalLayer.getBotDepth());
            }
            throw new SlownessModelException("Ray turns in the middle of this layer. \nlayerNum = " + layerNum + " sphericalRayParam " + sphericalRayParam + " sphericalLayer =  " + sphericalLayer + "\n");
        }
        if (sphericalLayer.getTopDepth() == sphericalLayer.getBotDepth()) {
            timedist.time = 0.0;
            timedist.dist = 0.0;
            return timedist;
        }
        if (sphericalRayParam == 0.0 && sphericalLayer.getBotDepth() == this.radiusOfEarth) {
            if (layerNum != this.getNumLayers(isPWave) - 1) {
                throw new SlownessModelException("There are layers deeper than the center of the earth!");
            }
            timedist.dist = 1.5707963267948966;
            timedist.time = sphericalLayer.getTopP();
            if (this.DEBUG) {
                System.out.println("Center of Earth: dist " + timedist.dist + " time " + timedist.time);
            }
            if (timedist.dist < 0.0 || timedist.time < 0.0 || Double.isNaN(timedist.time) || Double.isNaN(timedist.dist)) {
                throw new SlownessModelException("CoE timedist <0.0 or NaN: sphericalRayParam= " + sphericalRayParam + " botDepth = " + sphericalLayer.getBotDepth() + " dist=" + timedist.dist + " time=" + timedist.time);
            }
            return timedist;
        }
        if (Math.abs(topRadius / sphericalLayer.getTopP() - botRadius / sphericalLayer.getBotP()) < this.slownessTolerance) {
            double vel = botRadius / sphericalLayer.getBotP();
            double topTerm = topRadius * topRadius - sphericalRayParam * sphericalRayParam * vel * vel;
            if (Math.abs(topTerm) < this.slownessTolerance) {
                topTerm = 0.0;
            }
            double botTerm = sphericalRayParam == sphericalLayer.getBotP() ? 0.0 : botRadius * botRadius - sphericalRayParam * sphericalRayParam * vel * vel;
            double b = Math.sqrt(topTerm) - Math.sqrt(botTerm);
            timedist.time = b / vel;
            timedist.dist = Math.asin(b * sphericalRayParam * vel / (topRadius * botRadius));
            if (timedist.dist < 0.0 || timedist.time < 0.0 || Double.isNaN(timedist.time) || Double.isNaN(timedist.dist)) {
                throw new SlownessModelException("CVL timedist <0.0 or NaN: \nsphericalRayParam= " + sphericalRayParam + "\n botDepth = " + sphericalLayer.getBotDepth() + "\n topDepth = " + sphericalLayer.getTopDepth() + "\n topRadius=" + topRadius + " botRadius=" + botRadius + "\n dist=" + timedist.dist + "\n time=" + timedist.time + "\n b=" + b + "\n topTerm=" + topTerm + "\n botTerm=" + botTerm + "\n vel    =" + vel + "\n" + "\n bR^2   =" + botRadius * botRadius + "\n p^2v^2 =" + sphericalRayParam * sphericalRayParam * vel * vel + "\n tR^2   =" + topRadius * topRadius + "\n p^2v^2 =" + sphericalRayParam * sphericalRayParam * vel * vel);
            }
            return timedist;
        }
        return sphericalLayer.bullenRadialSlowness(sphericalRayParam, this.radiusOfEarth);
    }

    public boolean validate() throws SlownessModelException {
        boolean isOK = super.validate();
        double prevDepth = 0.0;
        boolean isPWave = true;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.getNumLayers(isPWave); ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                prevDepth = sLayer.getBotDepth();
                if (prevDepth > this.radiusOfEarth) {
                    isOK = false;
                    throw new SlownessModelException("Slowness layer has a depth larger than the radius of the earth in a spherical model. max depth = " + prevDepth + " radiusOfEarth = " + this.radiusOfEarth);
                }
                isOK |= true;
            }
            isPWave = false;
        }
        return isOK;
    }

    public Object clone() {
        SphericalSModel newObject = (SphericalSModel)super.clone();
        return newObject;
    }

    public String toString() {
        String desc = "spherical model:\n" + super.toString();
        return desc;
    }
}

