/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.PropertyLoader;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.Version;
import java.io.IOException;
import java.util.Properties;

public class TauP_Create {
    public transient boolean verbose = false;
    String modelFilename = "iasp91.tvel";
    protected String velFileType = "tvel";
    String directory = ".";
    SlownessModel sMod;
    VelocityModel vMod;
    TauModel tMod;
    boolean DEBUG = false;
    protected boolean GUI = false;
    protected Properties toolProps;

    public TauP_Create() {
        Alert.setGUI(this.GUI);
        try {
            this.toolProps = PropertyLoader.load();
        }
        catch (Exception e) {
            Alert.warning("Unable to load properties, using defaults.", e.getMessage());
            this.toolProps = new Properties();
        }
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setModelFilename(String modelFilename) {
        this.modelFilename = modelFilename;
    }

    public String getModelFilename() {
        return this.modelFilename;
    }

    public void setDEBUG(boolean DEBUG) {
        this.DEBUG = DEBUG;
    }

    public boolean getDEBUG() {
        return this.DEBUG;
    }

    public void setVelocityModel(VelocityModel vMod) {
        this.vMod = vMod;
    }

    public VelocityModel getVelocityModel() {
        return this.vMod;
    }

    public void setSlownessModel(SlownessModel sMod) {
        this.sMod = sMod;
    }

    public SlownessModel getSlownessModel() {
        return this.sMod;
    }

    public void setTauModel(TauModel tMod) {
        this.tMod = tMod;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public void printUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("\n   To specify the velocity model:");
        System.out.println("-nd modelfile       -- \"named discontinuities\" velocity file");
        System.out.println("-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n");
        System.out.println("-debug              -- enable debugging output\n-verbose            -- enable verbose output\n-version            -- print the version\n-help               -- print this out, but you already know that!\n\n");
    }

    protected String[] parseCmdLineArgs(String[] args) {
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-help")) {
                this.printUsage();
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                return noComprendoArgs;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.out.println(Version.getVersion());
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                return noComprendoArgs;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.verbose = true;
                this.DEBUG = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-gui")) {
                this.GUI = true;
                continue;
            }
            if (i < args.length - 1 && args[i].equalsIgnoreCase("-nd")) {
                this.velFileType = "nd";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (i < args.length - 1 && args[i].equalsIgnoreCase("-tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].startsWith("GB.")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".nd")) {
                this.velFileType = "nd";
                this.parseFileName(args[i]);
                continue;
            }
            if (args[i].endsWith(".tvel")) {
                this.velFileType = "tvel";
                this.parseFileName(args[i]);
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws SlownessModelException, TauModelException {
        System.out.println("TauP_Create starting...");
        TauP_Create tauPCreate = new TauP_Create();
        String[] noComprendoArgs = tauPCreate.parseCmdLineArgs(args);
        if (noComprendoArgs.length > 0) {
            int i;
            for (i = 0; i < noComprendoArgs.length; ++i) {
                if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                System.exit(0);
            }
            System.out.println("I don't understand the following arguments, continuing:");
            for (i = 0; i < noComprendoArgs.length; ++i) {
                System.out.print(noComprendoArgs[i] + " ");
            }
            System.out.println();
            noComprendoArgs = null;
        }
        try {
            tauPCreate.init();
            tauPCreate.start();
            System.out.println("Done!");
        }
        catch (IOException e) {
            System.out.println("Tried to read!\n Caught IOException " + e.getMessage() + "\nCheck that the file exists and is readable.");
        }
        catch (VelocityModelException e) {
            System.out.println("Caught VelocityModelException " + e.getMessage() + "\nCheck your velocity model.");
        }
    }

    public void parseFileName(String modelFilename) {
        int j = modelFilename.lastIndexOf(System.getProperty("file.separator"));
        this.modelFilename = modelFilename.substring(j + 1);
        this.directory = j == -1 ? "." : modelFilename.substring(0, j);
    }

    public void init() throws IOException, VelocityModelException {
        String file_sep = System.getProperty("file.separator");
        this.vMod = new VelocityModel();
        this.vMod.setFileType(this.velFileType);
        if (this.verbose) {
            System.out.println("filename =" + this.directory + file_sep + this.modelFilename);
        }
        this.vMod.readVelocityFile(this.directory + file_sep + this.modelFilename);
        if (this.verbose) {
            System.out.println("Done reading velocity model.");
            System.out.println("Radius of model " + this.vMod.getModelName() + " is " + this.vMod.getRadiusOfEarth());
        }
        if (this.DEBUG) {
            System.out.println(this.vMod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SlownessModelException, TauModelException {
        try {
            long prevTime = System.currentTimeMillis();
            String file_sep = System.getProperty("file.separator");
            if (this.vMod.getSpherical()) {
                this.sMod = new SphericalSModel();
            } else {
                System.out.println("Flat slowness model not yet implemented.\n   Using spherical slowness model.");
                this.sMod = new SphericalSModel();
            }
            this.sMod.DEBUG = this.DEBUG;
            this.sMod.setMinDeltaP(Double.valueOf(this.toolProps.getProperty("taup.create.minDeltaP", "0.1")));
            this.sMod.setMaxDeltaP(Double.valueOf(this.toolProps.getProperty("taup.create.maxDeltaP", "11.0")));
            this.sMod.setMaxDepthInterval(Double.valueOf(this.toolProps.getProperty("taup.create.maxDepthInterval", "115.0")));
            this.sMod.setMaxRangeInterval(Double.valueOf(this.toolProps.getProperty("taup.create.maxRangeInterval", "1.75")));
            this.sMod.setMaxInterpError(Double.valueOf(this.toolProps.getProperty("taup.create.maxInterpError", "0.05")));
            this.sMod.setAllowInnerCoreS(Boolean.valueOf(this.toolProps.getProperty("taup.create.allowInnerCoreS", "true")));
            if (this.verbose) {
                System.out.println("Parameters are:");
                System.out.println("taup.create.minDeltaP = " + this.sMod.getMinDeltaP() + " sec / radian");
                System.out.println("taup.create.maxDeltaP = " + this.sMod.getMaxDeltaP() + " sec / radian");
                System.out.println("taup.create.maxDepthInterval = " + this.sMod.getMaxDepthInterval() + " kilometers");
                System.out.println("taup.create.maxRangeInterval = " + this.sMod.getMaxRangeInterval() + " degrees");
                System.out.println("taup.create.maxInterpError = " + this.sMod.getMaxInterpError() + " seconds");
                System.out.println("taup.create.allowInnerCoreS = " + this.sMod.isAllowInnerCoreS());
            }
            this.sMod.createSample(this.vMod);
            long currTime = System.currentTimeMillis();
            if (this.verbose) {
                System.out.println("Slow model time=" + (currTime - prevTime) + " " + this.sMod.getNumLayers(true) + " P layers," + this.sMod.getNumLayers(false) + " S layers");
            }
            prevTime = currTime;
            if (this.DEBUG) {
                System.out.println(this.sMod);
            }
            this.tMod = new TauModel();
            this.tMod.DEBUG = this.DEBUG;
            this.tMod.calcTauIncFrom(this.sMod);
            currTime = System.currentTimeMillis();
            if (this.verbose) {
                System.out.println("T model time=" + (currTime - prevTime));
            }
            prevTime = currTime;
            if (this.DEBUG) {
                System.out.println("Done calculating Tau branches.");
            }
            if (this.DEBUG) {
                this.tMod.print();
            }
            String outFile = this.directory.equals(".") ? this.directory + file_sep + this.vMod.getModelName() + ".taup" : this.vMod.getModelName() + ".taup";
            this.tMod.writeModel(outFile);
            if (this.verbose) {
                System.out.println("Done Saving " + outFile);
            }
        }
        catch (IOException e) {
            System.out.println("Tried to write!\n Caught IOException " + e.getMessage() + "\nDo you have write permission in this directory?");
        }
        catch (VelocityModelException e) {
            System.out.println("Caught VelocityModelException " + e.getMessage());
        }
        finally {
            if (this.verbose) {
                System.out.println("Done!");
            }
        }
    }
}

