/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.Writer;

public class TauP_Curve
extends TauP_Time {
    protected boolean gmtScript = false;
    protected boolean reduceTime = false;
    protected double reduceVel = 0.002181661564992912;

    protected TauP_Curve() {
    }

    public TauP_Curve(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_Curve(String modelName) throws TauModelException {
        super(modelName);
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public boolean isReduceTime() {
        return this.reduceTime;
    }

    public void setReduceTime(boolean reduceTime) {
        this.reduceTime = reduceTime;
    }

    public double getReduceVelDeg() {
        return 57.29577951308232 * this.reduceVel;
    }

    public void setReduceVelDeg(double reduceVel) {
        if (reduceVel > 0.0) {
            this.reduceVel = Math.PI / 180 * reduceVel;
        }
    }

    public double getReduceVelKm() {
        return this.reduceVel * this.tMod.getRadiusOfEarth();
    }

    public void setReduceVelKm(double reduceVel) {
        if (reduceVel > 0.0) {
            this.reduceVel = this.tMod != null ? reduceVel / this.tMod.getRadiusOfEarth() : reduceVel / 6371.0;
        }
    }

    public void calculate(double degrees) {
        this.recalcPhases();
    }

    public void init() throws IOException {
        super.init();
        if (this.gmtScript) {
            String psFile = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            this.dos.writeBytes("#!/bin/sh\n");
            this.dos.writeBytes("#\n# This script will plot curves using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#\n");
            this.dos.writeBytes("/bin/rm -f " + psFile + "\n\n");
        }
    }

    public void printStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n");
    }

    public void printStdUsageTail() {
        System.out.println("\n-o outfile         -- output is redirected to \"outfile\" instead of taup_curve.gmt\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n\n");
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-gmt               -- outputs curves as a complete GMT script.");
        System.out.println("-reddeg velocity   -- outputs curves with a reducing velocity (deg/sec).");
        System.out.println("-redkm velocity    -- outputs curves with a reducing velocity (km/sec).");
        this.printStdUsageTail();
    }

    public void start() throws IOException, TauModelException {
        if (this.depth != -1.7976931348623157E308) {
            this.depthCorrect(Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0")));
            this.calculate(this.degrees);
            this.printResult(this.dos);
        } else {
            StreamTokenizer tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            System.out.print("Enter Depth: ");
            tokenIn.nextToken();
            double tempDepth = tokenIn.nval;
            if (tempDepth < 0.0 || this.depth > this.tMod.getRadiusOfEarth()) {
                System.out.println("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().\ndepth = " + tempDepth);
                return;
            }
            this.depthCorrect(tempDepth);
            this.calculate(this.degrees);
            this.printResult(this.dos);
        }
    }

    public void destroy() throws IOException {
        if (this.gmtScript) {
            this.dos.writeBytes("END\n");
        }
        super.destroy();
    }

    public void printResult(Writer out) throws IOException {
        double timeReduced;
        double arcDistance;
        double[] time;
        double[] dist;
        SeismicPhase phase;
        double maxTime = -1.7976931348623157E308;
        double minTime = Double.MAX_VALUE;
        if (this.gmtScript) {
            String scriptStuff = "";
            String psFile = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
            for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
                int i;
                phase = (SeismicPhase)this.phases.elementAt(phaseNum);
                dist = phase.getDist();
                time = phase.getTime();
                if (dist.length <= 0) continue;
                arcDistance = Math.acos(Math.cos(dist[dist.length - 1]));
                if (this.reduceTime) {
                    scriptStuff = scriptStuff + (float)(57.29577951308232 * arcDistance) + "  " + (float)(time[dist.length - 1] - arcDistance / this.reduceVel) + " 10 0 0 9 " + phase.getName() + "\n";
                    for (i = 0; i < time.length; ++i) {
                        timeReduced = time[i] - Math.acos(Math.cos(dist[i])) / this.reduceVel;
                        if (timeReduced > maxTime) {
                            maxTime = timeReduced;
                        }
                        if (!(timeReduced < minTime)) continue;
                        minTime = timeReduced;
                    }
                    continue;
                }
                scriptStuff = scriptStuff + (float)(57.29577951308232 * arcDistance) + "  " + (float)time[dist.length - 1] + " 10 0 0 1 " + phase.getName() + "\n";
                for (i = 0; i < time.length; ++i) {
                    if (time[i] > maxTime) {
                        maxTime = time[i];
                    }
                    if (!(time[i] < minTime)) continue;
                    minTime = time[i];
                }
            }
            maxTime = Math.ceil(maxTime / 100.0) * 100.0;
            minTime = Math.floor(minTime / 100.0) * 100.0;
            out.write("pstext -JX6 -P -R0/180/" + minTime + "/" + maxTime + " -B20/100/:.'" + this.modelName + "': -K > " + psFile + " <<END\n");
            out.write(scriptStuff);
            out.write("END\n\n");
            out.write("psxy -JX -R -M -O >> " + psFile + " <<END\n");
        }
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            phase = (SeismicPhase)this.phases.elementAt(phaseNum);
            dist = phase.getDist();
            time = phase.getTime();
            double[] rayParams = phase.getRayParams();
            if (dist.length > 0) {
                out.write("> " + phase.getName() + " for a source depth of " + this.depth + " kilometers in the " + this.modelName + " model\n");
            }
            block4: for (int i = 0; i < dist.length; ++i) {
                int j;
                Arrival[] phaseArrivals;
                arcDistance = Math.acos(Math.cos(dist[i]));
                timeReduced = this.reduceTime ? time[i] - arcDistance / this.reduceVel : time[i];
                out.write((float)(57.29577951308232 * arcDistance) + "  " + (float)timeReduced + "\n");
                if (i < dist.length - 1 && rayParams[i] == rayParams[i + 1] && rayParams.length > 2) {
                    out.write("> Shadow Zone\n");
                    continue;
                }
                if (i < dist.length - 1 && Math.sin(dist[i]) > 0.0 && Math.sin(dist[i + 1]) < 0.0) {
                    phase.calcTime(180.0);
                    phaseArrivals = phase.getArrivals();
                    for (j = 0; j < phaseArrivals.length; ++j) {
                        if (!((phase.rayParams[i] - phaseArrivals[j].rayParam) * (phaseArrivals[j].rayParam - phase.rayParams[i + 1]) > 0.0)) continue;
                        if (this.reduceTime) {
                            out.write("180.0  " + (float)(phaseArrivals[j].time - Math.PI / this.reduceVel) + "\n");
                            break;
                        }
                        out.write("180.0  " + (float)phaseArrivals[j].time + "\n");
                        break;
                    }
                }
                if (i >= dist.length - 1 || !(Math.sin(dist[i]) < 0.0) || !(Math.sin(dist[i + 1]) > 0.0)) continue;
                phase.calcTime(0.0);
                phaseArrivals = phase.getArrivals();
                for (j = 0; j < phaseArrivals.length; ++j) {
                    if (!((phase.rayParams[i] - phaseArrivals[j].rayParam) * (phaseArrivals[j].rayParam - phase.rayParams[i + 1]) > 0.0)) continue;
                    out.write("0.0  " + (float)phaseArrivals[j].time + "\n");
                    continue block4;
                }
            }
        }
    }

    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (leftOverArgs[i].equalsIgnoreCase("-gmt")) {
                this.gmtScript = true;
                continue;
            }
            if (leftOverArgs[i].equals("-reddeg")) {
                this.setReduceTime(true);
                this.setReduceVelDeg(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (leftOverArgs[i].equals("-redkm")) {
                this.setReduceTime(true);
                this.setReduceVelKm(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i].equals("-help") ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        boolean doInteractive = true;
        try {
            int i;
            TauP_Curve tauPCurve = new TauP_Curve();
            tauPCurve.outFile = "taup_curve.gmt";
            String[] noComprendoArgs = tauPCurve.parseCmdLineArgs(args);
            if (noComprendoArgs.length > 0) {
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                    System.exit(0);
                }
                System.out.println("I don't understand the following arguments, continuing:");
                for (i = 0; i < noComprendoArgs.length; ++i) {
                    System.out.print(noComprendoArgs[i] + " ");
                    if (!noComprendoArgs[i].equals("-help")) continue;
                    System.out.println();
                    System.exit(0);
                }
                System.out.println();
                noComprendoArgs = null;
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i] != "-h") continue;
                doInteractive = false;
            }
            if (tauPCurve.DEBUG) {
                System.out.println("Done reading " + tauPCurve.modelName);
            }
            tauPCurve.init();
            if (doInteractive) {
                tauPCurve.start();
            } else {
                tauPCurve.depthCorrect(Double.valueOf(tauPCurve.toolProps.getProperty("taup.source.depth", "0.0")));
                tauPCurve.calculate(tauPCurve.degrees);
                tauPCurve.printResult(tauPCurve.dos);
            }
            tauPCurve.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

