/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;

public class TauP_SetSac
extends TauP_Time {
    protected Vector sacFileNames = new Vector(10);
    protected boolean evdpkm = false;

    public boolean getEvdpkm() {
        return this.evdpkm;
    }

    public void setEvdpkm(boolean evdpkm) {
        this.evdpkm = evdpkm;
    }

    public void setSacFileNames(String[] sacFileNames) {
        this.sacFileNames.removeAllElements();
        for (int i = 0; i < sacFileNames.length; ++i) {
            this.sacFileNames.addElement(sacFileNames[i]);
        }
    }

    protected TauP_SetSac() {
    }

    public TauP_SetSac(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_SetSac(String modelName) throws TauModelException {
        super(modelName);
    }

    protected void setSacVarNums() {
        int i;
        boolean[] headersUsed = new boolean[10];
        for (i = 0; i < headersUsed.length; ++i) {
            headersUsed[i] = false;
        }
        for (i = 0; i < this.phaseNames.size() && i < 10; ++i) {
            if (((PhaseName)this.phaseNames.elementAt((int)i)).sacTNum == -1) continue;
            headersUsed[((PhaseName)this.phaseNames.elementAt((int)i)).sacTNum] = true;
        }
        for (int i2 = 0; i2 < this.phaseNames.size(); ++i2) {
            int j;
            if (((PhaseName)this.phaseNames.elementAt((int)i2)).sacTNum != -1) continue;
            for (j = 0; j < headersUsed.length && headersUsed[j]; ++j) {
            }
            if (j >= 10) continue;
            ((PhaseName)this.phaseNames.elementAt((int)i2)).sacTNum = j;
            headersUsed[j] = true;
        }
    }

    public void calculate(double degrees) {
        this.recalcPhases();
        this.calcTime(degrees);
    }

    public void init() throws IOException {
        super.init();
        this.setSacVarNums();
    }

    /*
     * WARNING - void declaration
     */
    public void start() throws IOException, TauModelException {
        SacTimeSeries sacFile = new SacTimeSeries();
        for (int i = 0; i < this.sacFileNames.size(); ++i) {
            void var3_4;
            double deg;
            System.out.println((String)this.sacFileNames.elementAt(i));
            sacFile.read((String)this.sacFileNames.elementAt(i));
            if (sacFile.evdp == -12345.0f) {
                System.out.println("Depth not set in " + (String)this.sacFileNames.elementAt(i) + ", skipping");
                continue;
            }
            if (sacFile.o == -12345.0f) {
                System.out.println("O marker not set in " + (String)this.sacFileNames.elementAt(i) + ", skipping");
                continue;
            }
            if (sacFile.gcarc != -12345.0f) {
                if (this.verbose) {
                    System.out.println("Using gcarc: " + sacFile.gcarc);
                }
                deg = sacFile.gcarc;
            } else if (sacFile.dist != -12345.0f) {
                if (this.verbose) {
                    System.out.println("Using dist: " + sacFile.dist);
                }
                deg = (double)sacFile.dist / 6371.0 * 180.0 / Math.PI;
            } else if (sacFile.stla != -12345.0f && sacFile.stlo != -12345.0f && sacFile.evla != -12345.0f && sacFile.evlo != -12345.0f) {
                if (this.verbose) {
                    System.out.println("Using stla,stlo, evla,evlo to calculate");
                }
                Alert.warning("Warning: Sac header gcarc is not set,", "using lat and lons to calculate distance.");
                Alert.warning("No ellipticity correction will be applied.", "This may introduce errors. Please see the manual.");
                deg = SphericalCoords.distance(sacFile.stla, sacFile.stlo, sacFile.evla, sacFile.evlo);
            } else {
                Alert.warning("Can't get a distance, all distance fields are undef.", "skipping " + (String)this.sacFileNames.elementAt(i));
                continue;
            }
            if (!(this.evdpkm && this.depth == (double)sacFile.evdp || !this.evdpkm && this.depth == (double)(1000.0f * sacFile.evdp))) {
                if (!this.evdpkm && sacFile.evdp != 0.0f && (double)sacFile.evdp < 1000.0) {
                    Alert.warning("Sac header evdp is < 1000 in " + (String)this.sacFileNames.elementAt(i), "If the depth is in kilometers instead of meters (default), you should use the -evdpkm flag");
                }
                if (this.evdpkm) {
                    this.depthCorrect(sacFile.evdp);
                } else {
                    this.depthCorrect((double)sacFile.evdp / 1000.0);
                }
            }
            if (this.verbose) {
                System.out.println(this.sacFileNames.elementAt(i) + " searching for " + this.getPhaseNameString());
            }
            this.calculate((double)var3_4);
            if (this.verbose) {
                System.out.println(this.sacFileNames.elementAt(i) + " " + this.arrivals.size() + " arrivals found.");
            }
            for (int arrivalNum = this.arrivals.size() - 1; arrivalNum >= 0; --arrivalNum) {
                int phaseNum = -1;
                for (int j = this.phaseNames.size() - 1; j >= 0; --j) {
                    if (!this.getArrival((int)arrivalNum).name.equals(((PhaseName)this.phaseNames.elementAt((int)j)).name)) continue;
                    phaseNum = j;
                    break;
                }
                if (phaseNum == -1) continue;
                if (this.verbose) {
                    System.out.println(this.sacFileNames.elementAt(i) + " phase found " + this.getArrival((int)arrivalNum).name + " -> t" + ((PhaseName)this.phaseNames.elementAt((int)phaseNum)).sacTNum + ", travel time=" + (float)this.getArrival((int)arrivalNum).time);
                }
                TauP_SetSac.setSacTHeader(sacFile, ((PhaseName)this.phaseNames.elementAt((int)phaseNum)).sacTNum, this.getArrival(arrivalNum));
            }
            sacFile.write((String)this.sacFileNames.elementAt(i));
        }
    }

    public static void setSacTHeader(SacTimeSeries sacFile, int headerNum, Arrival arrival) {
        switch (headerNum) {
            case 0: {
                sacFile.t0 = sacFile.o + (float)arrival.time;
                sacFile.kt0 = arrival.name;
                sacFile.user0 = (float)arrival.getRayParam();
                break;
            }
            case 1: {
                sacFile.t1 = sacFile.o + (float)arrival.time;
                sacFile.kt1 = arrival.name;
                sacFile.user1 = (float)arrival.getRayParam();
                break;
            }
            case 2: {
                sacFile.t2 = sacFile.o + (float)arrival.time;
                sacFile.kt2 = arrival.name;
                sacFile.user2 = (float)arrival.getRayParam();
                break;
            }
            case 3: {
                sacFile.t3 = sacFile.o + (float)arrival.time;
                sacFile.kt3 = arrival.name;
                sacFile.user3 = (float)arrival.getRayParam();
                break;
            }
            case 4: {
                sacFile.t4 = sacFile.o + (float)arrival.time;
                sacFile.kt4 = arrival.name;
                sacFile.user4 = (float)arrival.getRayParam();
                break;
            }
            case 5: {
                sacFile.t5 = sacFile.o + (float)arrival.time;
                sacFile.kt5 = arrival.name;
                sacFile.user5 = (float)arrival.getRayParam();
                break;
            }
            case 6: {
                sacFile.t6 = sacFile.o + (float)arrival.time;
                sacFile.kt6 = arrival.name;
                sacFile.user6 = (float)arrival.getRayParam();
                break;
            }
            case 7: {
                sacFile.t7 = sacFile.o + (float)arrival.time;
                sacFile.kt7 = arrival.name;
                sacFile.user7 = (float)arrival.getRayParam();
                break;
            }
            case 8: {
                sacFile.t8 = sacFile.o + (float)arrival.time;
                sacFile.kt8 = arrival.name;
                sacFile.user8 = (float)arrival.getRayParam();
                break;
            }
            case 9: {
                sacFile.t9 = sacFile.o + (float)arrival.time;
                sacFile.kt9 = arrival.name;
                sacFile.user9 = (float)arrival.getRayParam();
                break;
            }
        }
    }

    public void printStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list,\n                      use phase-# to specify the sac header,\n                      for example, ScS-8 puts ScS in t8\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
    }

    public void printStdUsageTail() {
        System.out.println("\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n");
    }

    public void printUsage() {
        this.printStdUsage();
        System.out.println("-evdpkm            -- sac depth header is in km, default is meters\n");
        this.printStdUsageTail();
        System.out.println("sacfilename [sacfilename ...]");
        System.out.println("\nEx: taup_setsac -mod S_prem -ph S-8,ScS-9 wmq.r wmq.t wmq.z");
        System.out.println("puts the first S arrival in T8 and ScS in T9");
    }

    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (leftOverArgs[i].equalsIgnoreCase("-evdpkm")) {
                this.evdpkm = true;
                continue;
            }
            if (leftOverArgs[i].equals("-help")) {
                noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
                continue;
            }
            File tempFile = new File(leftOverArgs[i]);
            if (tempFile.exists() && tempFile.isFile() && tempFile.canRead()) {
                this.sacFileNames.addElement(leftOverArgs[i]);
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauP_SetSac tauPSetSac = new TauP_SetSac();
        if (args.length == 0) {
            tauPSetSac.printUsage();
            System.exit(1);
        } else {
            try {
                String[] noComprendoArgs = tauPSetSac.parseCmdLineArgs(args);
                if (noComprendoArgs.length > 0) {
                    int i;
                    for (i = 0; i < noComprendoArgs.length; ++i) {
                        if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                        System.exit(0);
                    }
                    System.out.println("I don't understand the following arguments, continuing:");
                    for (i = 0; i < noComprendoArgs.length; ++i) {
                        System.out.print(noComprendoArgs[i] + " ");
                        if (!noComprendoArgs[i].equals("-help") && !noComprendoArgs[i].equals("-version")) continue;
                        System.out.println();
                        System.exit(0);
                    }
                    System.out.println();
                    noComprendoArgs = null;
                }
                if (tauPSetSac.DEBUG) {
                    System.out.println("Done reading " + tauPSetSac.modelName);
                }
                tauPSetSac.init();
                tauPSetSac.start();
            }
            catch (TauModelException e) {
                System.out.println("Caught TauModelException: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

