/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.XYPlot;
import java.awt.Container;
import java.awt.Graphics;
import java.util.Vector;

public class TimeDistPlot
extends XYPlot {
    public TimeDistPlot(Container parent) {
        super(parent);
        this.title = "Time/Distance";
        this.xLabel = "distance (deg)";
        this.yLabel = "time (sec)";
        this.xTickWidth = 10;
        this.yTickWidth = 200;
        this.minX = 0.0;
        this.maxX = 270.0;
        this.minY = 0.0;
        this.maxY = 2800.0;
    }

    public TimeDistPlot(Container parent, int width, int height) {
        super(parent, width, height);
        this.title = "Time/Distance";
        this.xLabel = "distance (deg)";
        this.yLabel = "time (sec)";
        this.xTickWidth = 10;
        this.yTickWidth = 200;
    }

    public void plot(TauModel tModel, boolean isPWave) {
        int waveNum;
        if (!isPWave) {
            waveNum = 1;
            this.minX = 0.0;
            this.maxX = 270.0;
            this.minY = 0.0;
            this.maxY = 2800.0;
        } else {
            waveNum = 0;
            this.minX = 0.0;
            this.maxX = 200.0;
            this.minY = 0.0;
            this.maxY = 1300.0;
        }
        this.zoomMinX = this.minX;
        this.zoomMaxX = this.maxX;
        this.zoomMinY = this.minY;
        this.zoomMaxY = this.maxY;
        int jj = 0;
        this.xSegments = new Vector();
        this.ySegments = new Vector();
        for (int i = 0; i < tModel.getNumBranches(); ++i) {
            jj = 0;
            double[] tempXData = new double[tModel.rayParams.length];
            double[] tempYData = new double[tModel.rayParams.length];
            for (int j = 0; j < tModel.rayParams.length; ++j) {
                double y = 0.0;
                double x = 0.0;
                for (int k = 0; k <= i; ++k) {
                    x += 2.0 * tModel.tauBranches[waveNum][k].getDist(j);
                    y += 2.0 * tModel.tauBranches[waveNum][k].time[j];
                }
                if (tModel.tauBranches[waveNum][i].time[j] == 0.0 && (i != 0 || (x *= 57.29577951308232) != 0.0)) continue;
                tempXData[jj] = x;
                tempYData[jj] = y;
                if (this.DEBUG) {
                    System.out.println(x + " " + y);
                }
                ++jj;
            }
            if (this.DEBUG) {
                System.out.println("> ");
            }
            this.xData = new double[jj];
            System.arraycopy(tempXData, 0, this.xData, 0, jj);
            this.yData = new double[jj];
            System.arraycopy(tempYData, 0, this.yData, 0, jj);
            this.xSegments.addElement(this.xData);
            this.ySegments.addElement(this.yData);
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
    }
}

