/*
 * Decompiled with CFR 0.152.
 */
package adams.core.gnuplot;

import adams.core.gnuplot.AbstractScriptlet;

public class MultiScriptlet
extends AbstractScriptlet {
    private static final long serialVersionUID = 6639840731369734498L;
    protected AbstractScriptlet[] m_Scriptlets;
    protected boolean m_UseSingleDataFile;

    public String globalInfo() {
        return "Allows the user to chain multiple scriplets together.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scriptlet", "scriptlets", (Object)new AbstractScriptlet[0]);
        this.m_OptionManager.add("use-single-data-file", "useSingleDataFile", (Object)false);
    }

    public void setScriptlets(AbstractScriptlet[] value) {
        this.m_Scriptlets = value;
        this.reset();
    }

    public AbstractScriptlet[] getScriptlets() {
        return this.m_Scriptlets;
    }

    public String scriptletsTipText() {
        return "The scriplets to use for producing a single script.";
    }

    public void setUseSingleDataFile(boolean value) {
        this.m_UseSingleDataFile = value;
        this.reset();
    }

    public boolean getUseSingleDataFile() {
        return this.m_UseSingleDataFile;
    }

    public String useSingleDataFileTipText() {
        return "If enabled, all sub-scriptlets get automatically updated to use this scriptlets data file.";
    }

    public String check() {
        String result = super.check();
        if (result == null) {
            int i;
            if (this.m_UseSingleDataFile) {
                for (i = 0; i < this.m_Scriptlets.length; ++i) {
                    this.m_Scriptlets[i].setDataFile(this.getDataFile());
                }
            }
            for (i = 0; i < this.m_Scriptlets.length && (result = this.m_Scriptlets[i].check()) == null; ++i) {
            }
        }
        return result;
    }

    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.m_Scriptlets.length; ++i) {
            result.append("# " + ((Object)((Object)this.m_Scriptlets[i])).getClass().getName() + "\n");
            result.append(this.m_Scriptlets[i].generate());
            result.append("\n");
        }
        return result.toString();
    }
}

