/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.BaseString;

public class BaseList
extends BaseString {
    private static final long serialVersionUID = -8131365256300704071L;

    public BaseList() {
        this("");
    }

    public BaseList(String s) {
        super(s);
    }

    protected Conversion getConversion() {
        return Conversion.UNCHANGED;
    }

    public boolean isValid(String value) {
        return super.isValid(this.convert(value));
    }

    protected String convert(String value) {
        String result;
        switch (this.getConversion()) {
            case UNCHANGED: {
                result = value;
                break;
            }
            case LOWER_CASE: {
                result = value.toLowerCase();
                break;
            }
            case UPPER_CASE: {
                result = value.toUpperCase();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled conversion: " + (Object)((Object)this.getConversion()));
            }
        }
        return result;
    }

    public String[] listValue() {
        String value = this.getValue();
        if (value.length() == 0) {
            return new String[0];
        }
        if (value.indexOf(44) == -1) {
            return new String[]{value};
        }
        return value.split(",");
    }

    public String getTipText() {
        return "An arbitrary comma-separated list.";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Conversion {
        UNCHANGED,
        LOWER_CASE,
        UPPER_CASE;

    }
}

