/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Placeholders;
import adams.core.management.OS;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Vector;

public class PlaceholderFile
extends File {
    private static final long serialVersionUID = 4767449993057576987L;

    public PlaceholderFile() {
        this("${CWD}");
    }

    public PlaceholderFile(File file) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(file.getAbsolutePath())));
    }

    public PlaceholderFile(String pathname) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(pathname)));
    }

    public PlaceholderFile(String parent, String child) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(parent)), child);
    }

    public PlaceholderFile(File parent, String child) {
        super(Placeholders.collapseStr(PlaceholderFile.fixSeparator(parent.getPath())), child);
    }

    public PlaceholderFile(URI uri) {
        super(uri);
    }

    public boolean canExecute() {
        return new File(this.expand(this.getPath())).canExecute();
    }

    public boolean canRead() {
        return new File(this.expand(this.getPath())).canRead();
    }

    public boolean canWrite() {
        return new File(this.expand(this.getPath())).canWrite();
    }

    public int compareTo(File pathname) {
        return new File(this.expand(this.getPath())).compareTo(new File(this.expand(pathname.getPath())));
    }

    public boolean createNewFile() throws IOException {
        return new File(this.expand(this.getPath())).createNewFile();
    }

    public boolean delete() {
        return new File(this.expand(this.getPath())).delete();
    }

    public void deleteOnExit() {
        new File(this.expand(this.getPath())).deleteOnExit();
    }

    public boolean exists() {
        return new File(this.expand(this.getPath())).exists();
    }

    public String getCanonicalPath() throws IOException {
        return new File(this.expand(this.getPath())).getCanonicalPath();
    }

    public long getFreeSpace() {
        return new File(this.expand(this.getPath())).getFreeSpace();
    }

    public long getTotalSpace() {
        return new File(this.expand(this.getPath())).getTotalSpace();
    }

    public long getUsableSpace() {
        return new File(this.expand(this.getPath())).getUsableSpace();
    }

    public boolean isAbsolute() {
        return new File(this.expand(this.getPath())).isAbsolute();
    }

    public boolean isDirectory() {
        return new File(this.expand(this.getPath())).isDirectory();
    }

    public boolean isFile() {
        return new File(this.expand(this.getPath())).isFile();
    }

    public boolean isHidden() {
        return new File(this.expand(this.getPath())).isHidden();
    }

    public long lastModified() {
        return new File(this.expand(this.getPath())).lastModified();
    }

    public long length() {
        return new File(this.expand(this.getPath())).length();
    }

    public String[] list() {
        return new File(this.expand(this.getPath())).list();
    }

    public String[] list(String regExp) {
        Vector<String> result = new Vector<String>();
        String[] list = new File(this.expand(this.getPath())).list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].matches(regExp)) continue;
            result.add(list[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public File[] listFiles() {
        return new File(this.expand(this.getPath())).listFiles();
    }

    public boolean mkdir() {
        return new File(this.expand(this.getPath())).mkdir();
    }

    public boolean renameTo(File dest) {
        File from = new File(this.expand(this.getPath()));
        File to = new File(this.expand(dest.getPath()));
        return from.renameTo(to);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setExecutable(executable, ownerOnly);
    }

    public boolean setLastModified(long time) {
        return new File(this.expand(this.getPath())).setLastModified(time);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setReadable(readable, ownerOnly);
    }

    public boolean setReadOnly() {
        return new File(this.expand(this.getPath())).setReadOnly();
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        return new File(this.expand(this.getPath())).setWritable(writable, ownerOnly);
    }

    public String getParent() {
        return new File(this.expand(this.getPath())).getParent();
    }

    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return new PlaceholderFile(p);
    }

    protected String expand(String path) {
        String result = path;
        if (result.indexOf("${") > -1) {
            result = Placeholders.getSingleton().expand(this.getPath());
        }
        return result;
    }

    public String getAbsolutePath() {
        File file = new File(this.expand(this.getPath()));
        String result = file.getAbsolutePath();
        return result;
    }

    protected static String fixSeparator(String path) {
        if (OS.isWindows()) {
            return path.replace('/', '\\');
        }
        return path.replace('\\', '/');
    }
}

