/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.CloneHandler;
import adams.core.Utils;
import adams.core.io.CsvSpreadSheetWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadSheet
implements Serializable,
CloneHandler<SpreadSheet> {
    private static final long serialVersionUID = -5500678849412481001L;
    public static final String COMMENT = "#";
    public static final String MISSING_VALUE = "?";
    protected Vector<String> m_RowKeys = new Vector();
    protected Hashtable<String, Row> m_Rows = new Hashtable();
    protected Row m_HeaderRow = new Row();
    protected Vector<String> m_Comments = new Vector();
    protected String m_Name = null;

    @Override
    public SpreadSheet getClone() {
        SpreadSheet result = new SpreadSheet();
        result.m_HeaderRow = this.m_HeaderRow.getClone();
        result.m_Comments = (Vector)this.m_Comments.clone();
        result.m_RowKeys = (Vector)this.m_RowKeys.clone();
        for (int i = 0; i < this.m_RowKeys.size(); ++i) {
            result.m_Rows.put(this.m_RowKeys.get(i), this.m_Rows.get(this.m_RowKeys.get(i)).getClone());
        }
        return result;
    }

    public void setName(String value) {
        this.m_Name = value;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean hasName() {
        return this.m_Name != null;
    }

    public void addComment(String comment) {
        this.m_Comments.add(comment);
    }

    public Vector<String> getComments() {
        return this.m_Comments;
    }

    public Row getHeaderRow() {
        return this.m_HeaderRow;
    }

    public boolean hasRow(String rowKey) {
        return this.m_Rows.containsKey(rowKey);
    }

    public Row addRow(String rowKey) {
        Row result;
        if (this.hasRow(rowKey)) {
            result = this.getRow(rowKey);
        } else {
            result = new Row();
            this.m_RowKeys.add(rowKey);
            this.m_Rows.put(rowKey, result);
        }
        return result;
    }

    public Row getRow(String rowKey) {
        return this.m_Rows.get(rowKey);
    }

    public Row getRow(int rowIndex) {
        return this.m_Rows.get(this.m_RowKeys.get(rowIndex));
    }

    public String getRowKey(int rowIndex) {
        return this.m_RowKeys.get(rowIndex);
    }

    public int getRowIndex(String rowKey) {
        int result = -1;
        for (int i = 0; i < this.m_RowKeys.size(); ++i) {
            if (!this.m_RowKeys.get(i).equals(rowKey)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int getCellIndex(String cellKey) {
        int result = -1;
        for (int i = 0; i < this.m_HeaderRow.getCellCount(); ++i) {
            if (!this.m_HeaderRow.getCellKey(i).equals(cellKey)) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean hasCell(String rowKey, String cellKey) {
        boolean result = this.hasRow(rowKey);
        if (result) {
            Row row = this.getRow(rowKey);
            result = row.hasCell(cellKey);
        }
        return result;
    }

    public Cell getCell(String rowKey, String cellKey) {
        Cell result = null;
        Row row = this.getRow(rowKey);
        if (row != null) {
            result = row.getCell(cellKey);
        }
        return result;
    }

    public String getCellPosition(String rowKey, String cellKey) {
        int rowIndex = this.getRowIndex(rowKey);
        int cellIndex = this.getCellIndex(cellKey);
        return SpreadSheet.getCellPosition(rowIndex + 1, cellIndex);
    }

    public static String getCellPosition(int row, int col) {
        Vector<Integer> digits;
        String result = null;
        if (col >= 18278) {
            throw new IllegalArgumentException("Column of cell too large: " + col + " >= " + 18278);
        }
        if (row == -1 || col == -1) {
            return result;
        }
        result = "";
        if (col < 26) {
            digits = Utils.toBase(col, 26);
        } else if (col < 702) {
            digits = Utils.toBase(col - 26, 26);
            while (digits.size() < 2) {
                digits.add(0);
            }
        } else {
            digits = Utils.toBase(col - 26 - 676, 26);
            while (digits.size() < 3) {
                digits.add(0);
            }
        }
        for (int i = digits.size() - 1; i >= 0; --i) {
            result = result + (char)(65 + digits.get(i));
        }
        result = result + (row + 1);
        return result;
    }

    public Enumeration<String> rowKeys() {
        return this.m_RowKeys.elements();
    }

    public void sort() {
        Collections.sort(this.m_RowKeys);
    }

    public void sort(Comparator<String> comp) {
        Collections.sort(this.m_RowKeys, comp);
    }

    public int getColumnCount() {
        return this.getHeaderRow().getCellCount();
    }

    public int getRowCount() {
        return this.m_RowKeys.size();
    }

    public boolean isNumeric(int columnIndex) {
        boolean result = true;
        String colKey = this.m_HeaderRow.getCellKey(columnIndex);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Cell cell = this.getRow(i).getCell(colKey);
            if (cell == null || cell.isNumeric()) continue;
            result = false;
            break;
        }
        return result;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        new CsvSpreadSheetWriter().write(this, writer);
        return writer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row
    implements Serializable,
    CloneHandler<Row> {
        private static final long serialVersionUID = -5657793858002845967L;
        protected Vector<String> m_CellKeys = new Vector();
        protected Hashtable<String, Cell> m_Cells = new Hashtable();

        @Override
        public Row getClone() {
            Row result = new Row();
            result.m_CellKeys = (Vector)this.m_CellKeys.clone();
            for (int i = 0; i < this.m_CellKeys.size(); ++i) {
                result.m_Cells.put(this.m_CellKeys.get(i), this.m_Cells.get(this.m_CellKeys.get(i)).getClone());
            }
            return result;
        }

        public boolean hasCell(String cellKey) {
            return this.m_Cells.containsKey(cellKey);
        }

        public Cell addCell(String cellKey) {
            Cell result;
            if (this.hasCell(cellKey)) {
                result = this.getCell(cellKey);
            } else {
                result = new Cell();
                this.m_CellKeys.add(cellKey);
                this.m_Cells.put(cellKey, result);
            }
            return result;
        }

        public Cell getCell(String cellKey) {
            return this.m_Cells.get(cellKey);
        }

        public Cell getCell(int columnIndex) {
            Cell result = null;
            String key = this.getCellKey(columnIndex);
            if (key != null) {
                result = this.getCell(key);
            }
            return result;
        }

        public String getContent(int columnIndex) {
            String result = null;
            String key = this.getCellKey(columnIndex);
            if (key != null) {
                result = this.getCell(key).getContent();
            }
            return result;
        }

        public Double toDouble(int columnIndex) {
            Double result = null;
            String key = this.getCellKey(columnIndex);
            if (key != null) {
                result = this.getCell(key).toDouble();
            }
            return result;
        }

        public String getCellKey(int columnIndex) {
            if (columnIndex < this.m_CellKeys.size()) {
                return this.m_CellKeys.get(columnIndex);
            }
            return null;
        }

        public Enumeration<String> cellKeys() {
            return this.m_CellKeys.elements();
        }

        public int getCellCount() {
            return this.m_Cells.size();
        }

        public String toString() {
            return this.m_Cells.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Cell
    implements Serializable,
    CloneHandler<Cell> {
        private static final long serialVersionUID = -3912508808391288142L;
        protected String m_Content = "";
        protected boolean m_IsNumeric = false;

        @Override
        public Cell getClone() {
            Cell result = new Cell();
            result.m_Content = this.m_Content;
            result.m_IsNumeric = this.m_IsNumeric;
            return result;
        }

        public void setContent(Integer value) {
            if (value == null) {
                this.setContent(SpreadSheet.MISSING_VALUE, true);
            } else {
                this.setContent("" + value, true);
            }
        }

        public void setContent(Double value) {
            if (value == null || Double.isNaN(value)) {
                this.setContent(SpreadSheet.MISSING_VALUE, true);
            } else {
                this.setContent("" + value, true);
            }
        }

        public void setContent(String value) {
            if (value.length() > 0 && !value.equals(SpreadSheet.MISSING_VALUE)) {
                if (Utils.isDouble(value)) {
                    this.setContent(value, true);
                } else {
                    this.setContent(value, false);
                }
            }
        }

        public void setContent(String value, boolean numeric) {
            this.m_Content = value;
            this.m_IsNumeric = numeric;
        }

        public String getContent() {
            return this.m_Content;
        }

        public boolean isNumeric() {
            return this.m_IsNumeric;
        }

        public boolean isMissing() {
            return this.m_Content.equals(SpreadSheet.MISSING_VALUE);
        }

        public String toString() {
            return this.getContent();
        }

        public boolean isDouble() {
            if (this.m_IsNumeric) {
                return Utils.isDouble(this.m_Content);
            }
            return false;
        }

        public Double toDouble() {
            if (this.m_IsNumeric) {
                return new Double(this.getContent());
            }
            return null;
        }

        public boolean isLong() {
            if (this.m_IsNumeric) {
                return Utils.isLong(this.m_Content);
            }
            return false;
        }

        public Long toLong() {
            if (this.m_IsNumeric) {
                return new Double(this.getContent()).longValue();
            }
            return null;
        }
    }
}

