/*
 * Decompiled with CFR 0.152.
 */
package adams.core.management;

import adams.core.io.FileUtils;
import adams.core.management.Java;
import adams.core.management.ProcessUtils;
import java.io.File;

public class JVisualVM
extends Java {
    public static final String EXECUTABLE = "jvisualvm";

    public static boolean isAvailable() {
        boolean result = JVisualVM.isJDK();
        if (result) {
            result = new File(JVisualVM.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE)).exists();
        }
        return result;
    }

    public static String getExecutablePath() {
        String result = JVisualVM.getBinDir() + File.separator + FileUtils.fixExecutable(EXECUTABLE);
        result = FileUtils.quoteExecutable(result);
        return result;
    }

    public static String getDefaultOptions() {
        return "--nosplash -J-Xmx512m";
    }

    public static String execute(long pid) {
        return JVisualVM.execute(JVisualVM.getExecutablePath(), pid);
    }

    public static String execute(String options, long pid) {
        return JVisualVM.execute(JVisualVM.getExecutablePath(), options, pid);
    }

    public static String execute(String executable, String options, long pid) {
        if (pid == -999L) {
            pid = ProcessUtils.getVirtualMachinePID();
        }
        options = options + " --openpid " + pid;
        return JVisualVM.execute(executable, options);
    }
}

