/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.base.BasePassword;
import adams.core.option.ActorExecutionClassProducer;
import adams.db.DatabaseConnection;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseActorExecutionClassProducer
extends ActorExecutionClassProducer {
    private static final long serialVersionUID = -8854002881512935904L;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;

    @Override
    public String globalInfo() {
        return "Generates a wrapper class for executing an actor that requires database access.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_URL = DatabaseConnection.getSingleton().getURL();
        this.m_User = DatabaseConnection.getSingleton().getUser();
        this.m_Password = DatabaseConnection.getSingleton().getPassword();
    }

    public void setURL(String value) {
        this.m_URL = value;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The JDBC URL of the database connection.";
    }

    public void setUser(String value) {
        this.m_User = value;
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The user used for connecting to the database.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password to use for connecting to the database.";
    }

    @Override
    protected List<String> getRequiredImports() {
        Vector<String> result = new Vector<String>(super.getRequiredImports());
        result.add(DatabaseConnection.class.getName());
        result.add(BasePassword.class.getName());
        return result;
    }

    @Override
    protected void addPreExecuteMethod() {
        this.m_OutputBuffer.append("  /**\n");
        this.m_OutputBuffer.append("   * Hook method before the actor is executed.\n");
        this.m_OutputBuffer.append("   * <p/>\n");
        this.m_OutputBuffer.append("   * Establishes the database connection.\n");
        this.m_OutputBuffer.append("   *\n");
        this.m_OutputBuffer.append("   * @param actor \t\tthe actor that will get executed.\n");
        this.m_OutputBuffer.append("   * @throws Exception \tif an error occurs.\n");
        this.m_OutputBuffer.append("   */\n");
        this.m_OutputBuffer.append("  protected void preExecute(AbstractActor actor) throws Exception {\n");
        this.m_OutputBuffer.append("    DatabaseConnection.getSingleton().reconnect(DatabaseConnection.getSingleton().getDriver(), \"" + this.getURL() + "\", \"" + this.getUser() + "\", new BasePassword(\"" + this.getPassword().stringValue() + "\"));\n");
        this.m_OutputBuffer.append("  }\n");
        this.m_OutputBuffer.append("\n");
    }
}

