/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.ConsoleObject;
import adams.core.Debuggable;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;

public abstract class OptionHandlingObject
extends ConsoleObject
implements OptionHandler,
Debuggable {
    private static final long serialVersionUID = -4086279255884465893L;
    protected OptionManager m_OptionManager;
    protected int m_DebugLevel;

    public OptionHandlingObject() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.finishInit();
    }

    public abstract String globalInfo();

    protected void initialize() {
    }

    protected void reset() {
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("D", "debugLevel", 0, 0, null);
    }

    protected void finishInit() {
    }

    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    public void destroy() {
        this.cleanUpOptions();
    }

    public void setDebugLevel(int value) {
        this.m_DebugLevel = value;
        this.getDebugging().setEnabled(value > 0);
        this.reset();
    }

    public int getDebugLevel() {
        return this.m_DebugLevel;
    }

    public String debugLevelTipText() {
        return "The greater the number the more additional info the scheme may output to the console (0 = off).";
    }

    protected boolean isDebugOn() {
        return this.m_DebugLevel > 0;
    }

    protected void debug(String msg) {
        this.debug(msg, 1);
    }

    protected void debug(String msg, int level) {
        if (level <= this.m_DebugLevel) {
            this.getDebugging().println(msg);
        }
    }

    public String toString() {
        return OptionUtils.getCommandLine(this);
    }

    public String toCommandLine() {
        return OptionUtils.getCommandLine(this);
    }
}

