/*
 * Decompiled with CFR 0.152.
 */
package adams.data.id;

import adams.data.id.AbstractIDFilenameGenerator;
import adams.data.id.DatabaseIDHandler;
import adams.data.id.IDHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIDGenerator
extends AbstractIDFilenameGenerator<Object> {
    private static final long serialVersionUID = -3963694054822483252L;
    public static final String PLACEHOLDER_ID = "{ID}";
    public static final String PLACEHOLDER_DATABASEID = "{DBID}";
    public static final String MISSING = "MISSING";
    protected String m_Format;

    @Override
    public String globalInfo() {
        return "A simple ID generator that can make use of data provided by classes implementing IDHandler and DatabaseIDHandler.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", "{DBID}-{ID}");
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format for the ID ({ID} = ID of IDHandler, {DBID} = database ID of DatabaseIDHandler).";
    }

    @Override
    protected String assemble(Object o) {
        String result = this.m_Format;
        result = o instanceof IDHandler ? result.replace(PLACEHOLDER_ID, ((IDHandler)o).getID().replace("'", "")) : result.replace(PLACEHOLDER_ID, MISSING);
        result = o instanceof DatabaseIDHandler ? result.replace(PLACEHOLDER_DATABASEID, "" + ((DatabaseIDHandler)o).getDatabaseID()) : result.replace(PLACEHOLDER_DATABASEID, MISSING);
        return result;
    }
}

