/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.ShallowCopySupporter;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import adams.data.report.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportWriter<T extends Report>
extends OptionHandlingObject
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractReportWriter> {
    private static final long serialVersionUID = 7030901991439712686L;
    protected PlaceholderFile m_Output;

    public abstract String getFormatDescription();

    public abstract String[] getFormatExtensions();

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", new PlaceholderFile(System.getProperty("java.io.tmpdir") + PlaceholderFile.separator + "out." + this.getFormatExtensions()));
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value == null ? new PlaceholderFile(".") : value;
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The file to write the report to.";
    }

    public boolean write(T data) {
        this.checkData(data);
        return this.writeData(data);
    }

    protected void checkData(T data) {
        if (this.m_Output.isDirectory()) {
            throw new IllegalStateException("No output file but directory provided ('" + this.m_Output + "')!");
        }
        if (!this.m_Output.getParentFile().exists()) {
            throw new IllegalStateException("Output file's directory '" + this.m_Output.getParentFile() + "' does not exist!");
        }
    }

    protected abstract boolean writeData(T var1);

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractReportWriter shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractReportWriter shallowCopy(boolean expand) {
        return (AbstractReportWriter)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getWriters() {
        return ClassLister.getSingleton().getClassnames(AbstractReportWriter.class);
    }

    public static AbstractReportWriter forName(String classname, String[] options) {
        AbstractReportWriter result;
        try {
            result = (AbstractReportWriter)OptionUtils.forName(AbstractReportWriter.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractReportWriter forCommandLine(String cmdline) {
        return (AbstractReportWriter)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

