/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMax
extends AbstractOutlierDetector<DataContainer> {
    private static final long serialVersionUID = 8061387654170301948L;
    protected Field m_field;
    protected double m_min;
    protected double m_max;

    @Override
    public String globalInfo() {
        return "Detects data containers where a report value is too high/low.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min", "min", 25.0);
        this.m_OptionManager.add("max", "max", 40.0);
        this.m_OptionManager.add("field", "field", new Field("Toluene-d8\tConc", DataType.NUMERIC));
    }

    public void setMin(double value) {
        this.m_min = value;
        this.reset();
    }

    public double getMin() {
        return this.m_min;
    }

    public String minTipText() {
        return "Min value of field in report.";
    }

    public void setMax(double value) {
        this.m_max = value;
        this.reset();
    }

    public double getMax() {
        return this.m_max;
    }

    public String maxTipText() {
        return "Max value of field in report.";
    }

    public void setField(Field value) {
        this.m_field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_field;
    }

    public String fieldTipText() {
        return "Field in report.";
    }

    @Override
    protected Vector<String> processData(DataContainer data) {
        Vector<String> result = new Vector<String>();
        String msg = "";
        Report report = null;
        if (data instanceof ReportHandler) {
            report = (Report)((ReportHandler)((Object)data)).getReport();
        }
        if (report == null) {
            msg = "No report available";
            result.add(msg);
        } else {
            Double value = report.getDoubleValue(this.m_field);
            if (value == null) {
                msg = "Field '" + this.m_field + "' not found";
                result.add(msg);
            } else if (value < this.m_min) {
                msg = this.m_field + " too small (< " + this.m_min + ") : " + value;
                result.add(msg);
            } else if (value > this.m_max) {
                msg = this.m_field + " too big (> " + this.m_max + "): " + value;
                result.add(msg);
            }
        }
        if (this.isDebugOn()) {
            this.debug(data + " - " + this.getClass().getName() + ": " + msg);
        }
        return result;
    }
}

