/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetRequired
extends AbstractOutlierDetector {
    private static final long serialVersionUID = -6838687006986727555L;
    protected Field m_Field;
    protected double m_MinConcentration;

    @Override
    public String globalInfo() {
        return "Checks whether the specified target field is available in the report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field("benzene\tConc", DataType.NUMERIC));
        this.m_OptionManager.add("conc", "minConcentration", 0.0);
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to use (ie, the class).";
    }

    public void setMinConcentration(double value) {
        this.m_MinConcentration = value;
        this.reset();
    }

    public double getMinConcentration() {
        return this.m_MinConcentration;
    }

    public String minConcentrationTipText() {
        return "The minimum concentration that the target value must have.";
    }

    protected Vector<String> processData(DataContainer data) {
        Vector<String> result = new Vector<String>();
        if (data instanceof ReportHandler) {
            ReportHandler handler = (ReportHandler)((Object)data);
            if (handler.getReport() != null) {
                Object t = ((Report)handler.getReport()).getValue(this.m_Field);
                if (t == null) {
                    result.add("Target value '" + this.m_Field + "' not in report!");
                } else if (!(t instanceof Double)) {
                    result.add("Target value '" + this.m_Field + "' not of type Double!");
                } else if ((Double)t < this.m_MinConcentration) {
                    result.add("Target value '" + this.m_Field + "' does not meet minimum concentration of " + this.m_MinConcentration + ", " + t + " instead!");
                }
            } else {
                result.add("No report available!");
            }
        } else {
            result.add("Data container does not handle reports!");
        }
        return result;
    }
}

